#import <AppKit/AppKit.h>

@interface ReminderController : NSObject
{
    id absoluteRelativeMatrix;
    id addButton;
    id addMenuItem;
    id soundOnOffMatrix;
    id cancelButton;
    id cancelMenuItem;
    id dateField;
    id dayField;
    id deleteButton;
    id deleteMenuItem;
    id hoursField;
    id hoursSlider;
    id mainMenu;
    id mainWindow;
    id minutesField;
    id minutesSlider;
    id monthField;
    id repeatOnOffMatrix;
    id panelOnOffMatrix;
    id reminderMessageField;
    id remindersTable;
    id replaceButton;
    id replaceMenuItem;
    id secondsField;
    id secondsSlider;
    id timeField;

    NSMutableArray *reminderArray;
}

- (void)addReminder:(id)sender;
- (BOOL)addReminder:(id)sender atIndex:(int)rowIndex;
- (void)applicationDidFinishLaunching:(NSNotification *)notification;
- (BOOL)applicationShouldTerminate:(NSApplication *)sender;
- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)theApplication;
- (void)cancelReminderIdenticalTo:(id)aReminder;
- (void)cancelSelectedReminder:(id)sender;
- (void)deleteReminderIdenticalTo:(id)aReminder;
- (void)deleteSelectedReminder:(id)sender;
- (int)numberOfRowsInTableView:(NSTableView *)theTableView;
- (void)reloadData;
- (void)reminderDue:(NSTimer *)sender;
- (void)replaceReminder:(id)sender;
- (void)setAbsoluteOrRelative:(id)sender;
- (void)setOnceOrRepeats:(id)sender;
- (void)showWindow:(id)sender;
- (id)tableView:(NSTableView *)theTableView objectValueForTableColumn: (NSTableColumn *)theColumn row:(int)rowIndex;
- (void)takeIntValueFrom:(id)sender;
- (void)textDidEndEditing:(NSNotification *)aNotification;
- (void)updateControls;

@end
