/* PrefPanelController.m created by lindberg on Fri 08-Oct-1999 */

#import "PrefPanelController.h"
#import <AppKit/NSTableView.h>
#import <AppKit/NSTextField.h>
#import <AppKit/NSButton.h>
#import <AppKit/NSOpenPanel.h>

@implementation PrefPanelController

+ (id)allocWithZone:(NSZone *)aZone
{
    return [self sharedInstance];
}

+ (id)sharedInstance
{
    static id instance = nil;
    if (instance == nil)
        instance = [[super allocWithZone:NULL] initWithWindowNibName:@"PrefPanel"];
    return instance;
}

- (id)initWithWindowNibName:(NSString *)nibName
{
    self = [super initWithWindowNibName:nibName];
    [self setWindowFrameAutosaveName:@"Preferences"];
    [self setShouldCascadeWindows:NO];
    manPathArray = [[NSMutableArray alloc] init];

    return self;
}

- (void)dealloc
{
    [manPathArray release];
    [super dealloc];
}

- (void)windowDidLoad
{
    [super windowDidLoad];

	[manPathTableView sizeToFit];
    [self revertFromDefaults:nil];
}

- (IBAction)revertFromDefaults:(id)sender
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    NSEnumerator *manPathEnum;
    NSString *manPath;
    NSString *path;

    [lastClosedSwitch setState:[defaults boolForKey:@"QuitWhenLastClosed"]];
    [useItalicsSwitch setState:[defaults boolForKey:@"UseItalics"]];
    [useBoldSwitch    setState:[defaults boolForKey:@"UseBold"]];
    [nroffCommandField setStringValue:[defaults stringForKey:@"NroffCommand"]];

    manPath = [defaults stringForKey:@"ManPath"];
    manPathEnum = [[manPath componentsSeparatedByString:@":"] objectEnumerator];
    while (path = [manPathEnum nextObject])
    {
        [manPathArray addObject:[path stringByAbbreviatingWithTildeInPath]];
    }

    [manPathTableView reloadData];
}

- (IBAction)saveToDefaults:(id)sender
{
    NSUserDefaults *defaults = [NSUserDefaults standardUserDefaults];
    int i, count = [manPathArray count];
    NSMutableArray *rawPathArray = [NSMutableArray arrayWithCapacity:count];

    [defaults setBool:[lastClosedSwitch state] forKey:@"QuitWhenLastClosed"];
    [defaults setBool:[useItalicsSwitch state] forKey:@"UseItalics"];
    [defaults setBool:[useBoldSwitch state]    forKey:@"UseBold"];
    [defaults setObject:[nroffCommandField stringValue] forKey:@"NroffCommand"];

    for (i=0; i<count; i++)
    {
        NSString *path = [manPathArray objectAtIndex:i];
        [rawPathArray addObject:[path stringByExpandingTildeInPath]];
    }

    [defaults setObject:[rawPathArray componentsJoinedByString:@":"] forKey:@"ManPath"];
}

- (IBAction)addPath:(id)sender
{
    NSOpenPanel *panel = [NSOpenPanel openPanel];

    [panel setAllowsMultipleSelection:NO];
    [panel setCanChooseDirectories:YES];
    [panel setCanChooseFiles:NO];

    if ([panel runModal])
    {
        NSString *path = [[panel filename] stringByAbbreviatingWithTildeInPath];
        if (![manPathArray containsObject:path])
        {
			int insertionIndex = [manPathTableView selectedRow];

			if (insertionIndex < 0)
				insertionIndex = [manPathArray count]; //add it on the end

            [manPathArray insertObject:path atIndex:insertionIndex];
            [manPathTableView reloadData];
            [self saveToDefaults:nil];
        }
    }
}

- (IBAction)removePath:(id)sender
{
    int selectedIndex = [manPathTableView selectedRow];

    if (selectedIndex >= 0)
    {
        [manPathArray removeObjectAtIndex:selectedIndex];
        [manPathTableView reloadData];
        [self saveToDefaults:nil];
    }
}

/** NSTableView data source **/

- (int)numberOfRowsInTableView:(NSTableView *)tableView
{
    return [manPathArray count];
}

- (id)tableView:(NSTableView *)tableView
   objectValueForTableColumn:(NSTableColumn *)tableColumn row:(int)row
{
    return [manPathArray objectAtIndex:row];
}

- (void)tableView:(NSTableView *)tableView setObjectValue:(id)object
   forTableColumn:(NSTableColumn *)tableColumn row:(int)row
{
}

@end
