#import "ActionData.h"

#import "LayerProtocol.h"


typedef enum {I_ACTION, I_MODIFIER, I_EXTENSION} InterfaceType;


@interface Interface: NSObject
{
@protected
	id		inspectorView;			// the NSBox containing all controls
	id		detailView;			// the NSBox for (opt.) detail stuff
	id		initialFirstResponder;	// the NSResponder which should be key
	NSWindow	*_inspectorPanel;		// automatic maintenance of release
}

// An interface is by default of type I_ACTION (for brushable actions)
// If your interface/engine pair is not of this kind, override and return
// the proper value
// (I_EXTENSION is not supported yet)
+ (InterfaceType) interfaceType;

// **************************************************
// EngineData handling: necessary for proper function
// you MUST override AND message super
// **************************************************
- initWithEngineData: (EngineData *)data;
+ (void)modifyDataToReflectDefaults: (EngineData *)data;
- (void)modifyDataToReflectSettings: (EngineData *)data;
- (void)updateToReflectEngineData: (EngineData *)data;


// with standard naming conventions, these methods 
// DO NOT NEED to be overridden - things will work automagically.
// if overridden, DO NOT message super
+ (NSString *) iconRootName;
+ (NSImage *) icon;

// preview icon: the action / engine interface is queried in this
// order, in decreasing priority. the first non-nil return value is
// used if it contains valid data.
// if the interface class returns only a path it automatically instantiates
// (and caches) the appropriate icon. the path can be absolute, relative
// to home, or relative within the bundle wrapper.
// override only if you want to alter the default behavior; you are
// then responsible to return valid data.

extern NSString *previewIconKey, *previewFileNameKey;

+ (NSImage *) previewIconForEngineData:(EngineData *)data;
+ (NSString *) previewIconPathForEngineData:(EngineData *)data;


- (NSString *) nibName;
- (NSBox *) inspectorView;
- (NSBox *) detailView;
- (NSResponder *) initialFirstResponder;

// returns a localized string table for the WHOLE BUNDLE
// File is named "Localized.strings"
// The returned value is statci and must not be retained or released
// nor otherwise modified.
// You DO NOT need to override this method
+ (NSDictionary *) mainStringTable;
+ (NSString *) localizedStringForKey:(NSString *)key;


// returns the default comment string to be placed in an action's comment
// field. can describe the general function of the module, commands for
// a parser, or whatever. the user then can modify each individual instance.
// this method is automatically invoked by modifyDataToReflectDefaults
// unless there is already a comment present.
// method automatically uses the "Localized.strings" main string table
// of the action. YOU DO NOT NEED to override this, it works automagically.
// Key searched is "[InterfaceClassName]Comment"
+ (NSString *) defaultEngineComment;


// return YES only if your inspector supports proper resizing
// and this behavior is truly necessary (in general a bad idea)
- (BOOL) wantsResizableInspector;


// DO NOT message to super
+ (void)customMouseDown: (NSPoint)point
		layer: (id <Layer>)layer
		document: (id <Document>)document;

+ (void)customMouseDragged: (NSPoint)point
		layer: (id <Layer>)layer
		document: (id <Document>)document;

+ (void)customMouseUp: (NSPoint)point
		layer: (id <Layer>)layer
		document: (id <Document>)document;

// DO NOT message to super
- (void)customMouseDown: (NSPoint)point
		layer: (id <Layer>)layer
		document: (id <Document>)document;

- (void)customMouseDragged: (NSPoint)point
		layer: (id <Layer>)layer
		document: (id <Document>)document;

- (void)customMouseUp: (NSPoint)point
		layer: (id <Layer>)layer
		document: (id <Document>)document;

// notifies of a context switch (user switched the active document)
// when an inspector is open. If you override this method, you MUST
// message super prior to performing your own adjustments.
- (void) contextSwitch;

// called before an inspector is brought up
// If you override this method, you MUST
// message super prior to performing your own adjustments.
- (void) willShowInspector;

// called before an inspector is closed, be it successful or not
// If you override this method, you MUST
// message super prior to performing your own adjustments.
- (void) willCloseInspector;

// sent when the user selects an action/modifier of a given class
// in the Action Catalogue
// this method has the opportunity to do whatever may be necessary
+ (void) interfaceSelected;
+ (void) interfaceDeselected;

+ (void)applicationWillTerminate:(NSNotification *)n;

@end
