/* DocumentProtocol.h created by stanj on Sun 30-Nov-1997 */


@class LayerGroup, MarqueeGroup, UndoHistory, GroupObject;

typedef enum {	EXPORT_T3FILE, 
			EXPORT_TIFF_COMP, 
			EXPORT_TIFF_LAYERS,
			EXPORT_EPS1,
			EXPORT_EPSRL,
			EXPORT_EPSJPG,
			EXPORT_JPEG,
			EXPORT_ASK
} ExportType;


@protocol Document <NSObject>

/* new doc */
- (void) setDocumentName:(NSString *)n;
- (NSString *) documentName;
- (void) setDefaultExportSettings:(NSDictionary *)et;
- (NSDictionary *) defaultExportSettings;

- initFromFile:(NSString *)file;

/* gui */
- (void) spawnView;
- (void) spawnViewAtWindow:(NSWindow *)w;
- (NSArray *) documentViews;

- (void) purgeCaches;
- (void) displayAll;
- (void) displayAllRect:(NSRect)r;
- (void) close;

- (NSSize) boundingSize;
- (NSRect) boundingBox;
- (NSRect) layerBoundingBox;

/* representation */
- (LayerGroup *) rootLayer;
- (void) addLayer:(GroupObject *)img;
- (void) addLayers:(NSArray *)imgs;
- (void) removeLayer:(GroupObject *)img;
- (NSArray *) layerList;
- (NSSet *) pureLayerSet;

- (MarqueeGroup *) rootMarquee;
- (void) addMarquee:(GroupObject *)img;
- (void) addMarquee:(GroupObject *)img active:(BOOL)a;
- (void) removeMarquee:(GroupObject *)img;
- (NSArray *) marqueeList;

- (void) removeGroupObject:(GroupObject *)go;
- (void) addGroupObject:(GroupObject *)go;

/* jobs */
- (BOOL) isIdle;

- (void) notifyMayChange;
- (void) notifyDidChange;
- (void) notifyDidRearrange;

- (BOOL) isEdited;
- (void) clearEdited;
- (int) uniqueStamp;

- (BOOL) isRevertable;
- (void) makeRevertable;

- (UndoHistory *) undoHistory;

@end
