/* AppReq.h created by stanj on Tue 24-Dec-1996 */

#import "TIFFany3.h"


#import "ContextProtocol.h"
#import "DocumentQuery.h"
#import "PixelSource.h"

@interface TIFFany3 (Public)

+ (TIFFany3 *) application;

// returns the currently key context (image window)
// see DocQuery protocol
- (id <DocumentQuery>) activeContext;

// the general usage pasteboard
- (NSPasteboard *) pasteboard;
// returns a bitmap that can be used within TIFFany from the pb.
- (id <PixelSource>) bitmapFromPasteboard:(NSPasteboard *)pb;

// USE THIS METHOD for localizing
// see "publicDefines.h" macro "LST(@"xyz-string")"
- (NSString *) localizedString:(NSString *)key;

- (BOOL) isExpertMode;

- (NSFont *)baseFontOfSize:(float)s;

@end
