#import "MosaicInterface.h"


@implementation MosaicInterface

// Register for textDidChange notifications.
- initWithEngineData: (ActionData *)data
{
	self = [super initWithEngineData: data];
	if(self)
	{
		[[NSNotificationCenter defaultCenter]
			addObserver: self
			selector: @selector(textDidChange:)
			name: NSControlTextDidChangeNotification
			object: sizeField];
	}

	return self;
}

// Cleanup. If there's still a size object there, release it.
- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver: self];
	[size release];

	[super dealloc];
}


// Write the default parameters to the ActionData object.
+ (void)modifyDataToReflectDefaults: (ActionData *)data
{
	[super modifyDataToReflectDefaults: data];

	[data setObject: @"4.0 points"  forKey: @"Size"];
}

// Save the parameters from the UI to the ActionData object.
- (void)modifyDataToReflectSettings: (ActionData *)data
{
	[super modifyDataToReflectSettings: data];

	[data setObject: [size fullStringValue]  forKey: @"Size"];
}

// Update the UI to reflect the ActionData's parameters.
- (void)updateToReflectEngineData: (ActionData *)data
{
	[super updateToReflectEngineData: data];

	[size release];
	size = [[CSMeasurementUnit alloc] initWithStringValue:
				[data objectForKey: @"Size"]];

	[sizeField setStringValue: [size stringValue]];
	[sizeSlider setDoubleValue: [size value]];
}


// The slider has moved, update the TextField.
- (void)sliderMoved: sender
{
	[size setValue: [sizeSlider doubleValue]];
	[size roundToDigits];
	[sizeField setStringValue: [size stringValue]];
}

// The user typed something: Update the slider.
- (void)textDidChange: (NSNotification *)notification
{
	[size setStringValue: [sizeField stringValue]];
	[sizeSlider setDoubleValue: [size value]];
}

@end
