//************************************************************************
//
//	HTTPSSessionQueue.m
//
//	by Juergen Moellenhoff <jm@oic.de>		
//
//
//	This code is supplied "as is" the author makes no warranty as to its
//	suitability for any purpose.  This code is free and may be distributed
//	in accordance with the terms of the:
//		
//			GNU GENERAL PUBLIC LICENSE
//			Version 2, June 1991
//			copyright (C) 1989, 1991 Free Software Foundation, Inc.
// 			675 Mass Ave, Cambridge, MA 02139, USA
//
//************************************************************************

#import "HTTPSSessionQueue.h"
#import "HTTPSSession.h"
#import <OmniFoundation/OFDatedMutableDictionary.h>
#import	<OmniBase/rcsid.h>

RCS_ID("$Header: /LocalDeveloper/CVS/HTTPS/HTTPSSessionQueue.m,v 1.5 1999/06/22 15:14:06 jurgen Exp $")

@implementation HTTPSSessionQueue 

static OFDatedMutableDictionary *httpsCache;

+ (void)initialize
{
    static BOOL initialized = NO;

    [super initialize];
    if (initialized)
        return;
    initialized = YES;

    httpsCache = [[OFDatedMutableDictionary alloc] init];
}

+ (Class)sessionClass
{
    return [HTTPSSession class];
}

+ (OFDatedMutableDictionary *)cache
{
    return httpsCache;
}

- (BOOL)shouldPipelineRequests
{
    return NO;
}

@end
