//************************************************************************
//
//	HTTPSSession.m
//
//	by Juergen Moellenhoff <jm@oic.de>		
//
//
//	This code is supplied "as is" the author makes no warranty as to its
//	suitability for any purpose.  This code is free and may be distributed
//	in accordance with the terms of the:
//		
//			GNU GENERAL PUBLIC LICENSE
//			Version 2, June 1991
//			copyright (C) 1989, 1991 Free Software Foundation, Inc.
// 			675 Mass Ave, Cambridge, MA 02139, USA
//
//************************************************************************

/*
  This class is a (BIG) dirty hack and I have some ideas for a better way to implement it (actually the SSL-Tunneling is the biggest problem because I can't handle it like a http proxy connection) but I have not the time to develop such a class, maybe in the future I have more time.
*/

#import "HTTPSSession.h"

#import "HTTPSInformation.h"
#import "HTTPSProcessor.h"
#import "SSLSocket.h"
#import "HTTPSPreferences.h"
#import "HTTPSFunctions.h"
#import "OWTask+HTTPSExtension.h"
#import "HTTPSUtilities.h"

#import	<OmniBase/rcsid.h>
#import	<OmniBase/OBUtilities.h>

#import	<OmniFoundation/OmniFoundation.h>
#import <OWF/OWF.h>
#import <OWF/OWHTTPProcessor.h>
#import <OWF/OWHTTPSessionQueue.h>

#import <OmniNetworking/ONHost.h>
#import <OmniNetworking/ONSocketStream.h>

RCS_ID("$Header: /LocalDeveloper/CVS/HTTPS/HTTPSSession.m,v 1.6 1999/06/22 15:34:49 jurgen Exp $")

@interface OWHTTPSession(HTTPSPrivateMethods)
- (void)connect;
- (void)disconnect;
- (BOOL)fetchForProcessor:(OWHTTPProcessor *)aProcessor inPipeline:(OWPipeline *)aPipeline;
- (NSString *)userAgentHeaderStringForURL:(OWURL *)aURL;
- (NSString *)authorizationStringForURL:(OWURL *)aURL;
- (NSString *)requestStringForProcessor:(OWHTTPProcessor *)aProcessor;
- (BOOL)sendRequest;
- (BOOL)sendRequests;
@end

@implementation HTTPSSession

static	NSLock			*infoUserLock = nil;

static	NSString		*HTTPSTunnelingString = nil;
static	NSString		*HTTPSStatusString = nil;

+ (void)initialize 
{
	static BOOL fInitialized = NO;

	[super initialize];
	if (fInitialized)
		return;
    fInitialized = YES;

	infoUserLock = [[NSLock alloc] init];

	HTTPSTunnelingString = [NSLocalizedStringFromTableInBundle(@"HTTPSTunnelingString", nil, CLASS_BUNDLE, @"Tunneling string.") retain];
	HTTPSStatusString = [NSLocalizedStringFromTableInBundle(@"HTTPSStatusString", nil, CLASS_BUNDLE, @"Status string.") retain];
}

+ (int)defaultPort
{
	return 443;
}

+ (void)didLoad
{
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(controllerDidInit:) name:OFControllerDidInitNotification object:nil];
}

+ (Class)socketClass
{
	return [SSLSocket class];
}

- (void)_infoUser:(HTTPSProcessor *)aProcessor
{
	[[HTTPSInformation sharedHTTPSInformation] runModalWithSession:self andProcessor:aProcessor];

    [infoUserLock unlock]; // Unblocks the -connect method in the other thread
}

- (void)_logConnectionInfo:(HTTPSProcessor *)aProcessor
{
	SSLSocket	*sslSocket = (SSLSocket *)[socketStream socket];

	NSLog(@"SSL connection: URL=[%@], Cipher=[%@] Protocol=[%@] Keylen=[%d bits]", 
		[[(OWAddress *)[[aProcessor pipeline] lastAddress] url] netLocation], [sslSocket cipherString], [sslSocket protocolString], [sslSocket bits]);
}

- (void)_connectionInfos:(HTTPSProcessor *)aProcessor
{
	BOOL	fAbort = NO;
	static	BOOL disablePanel = NO;

	if ([[OFUserDefaults sharedUserDefaults] boolForKey:HTTPSDebugLog])
		[self _logConnectionInfo:aProcessor];

	if (![[aProcessor pipeline] isTopTask])
		return;

	if ([[OFUserDefaults sharedUserDefaults] boolForKey:HTTPSWarningPanelEnabled] && !disablePanel)
	{
        if (![[[aProcessor pipeline] target] isKindOfClass:NSClassFromString(@"OWBookmarkEntry")])
		{	// No Panel for Bookmark checking
			[infoUserLock lock];
    		[self mainThreadPerformSelector:@selector(_infoUser:) withObject:aProcessor];
    		[infoUserLock lock]; // This will block until _infoUser unlocks it from the main thread
			fAbort = [[HTTPSInformation sharedHTTPSInformation] canceled];
			disablePanel = [[HTTPSInformation sharedHTTPSInformation] disablePanel];
    		[infoUserLock unlock];

			if (fAbort)
			{
				// [OWPipeline abortPipelinesForTarget:[[aProcessor pipeline] target]];
				[NSException raise:HTTPSSessionUserAbortExceptionName format:@"HTTPSSession: Request canceled by user"];
			}
		}
	}
	else
	{
		if (![[OFUserDefaults sharedUserDefaults] boolForKey:HTTPSDebugLog])
			[self _logConnectionInfo:aProcessor];
	}
}

- (BOOL)_tunnelConnectForProcessor:(HTTPSProcessor *)aProcessor
{
	BOOL			fConnect = NO;
	NSString		*returnString, *portString; 
	NSMutableString	*connectString;
    OWWebPipeline	*aPipeline;
    OWAddress		*anAddress;
    OWURL			*aURL;
	int				realPort, proxyPort;

    aPipeline = (OWWebPipeline *)[aProcessor pipeline];
    anAddress = (OWAddress *)[aPipeline lastAddress];
    aURL = [anAddress url];

	// Status message
	proxyPort = ([proxyLocation port] != nil) ? [[proxyLocation port] intValue] : [[self class] defaultPort];
	[aProcessor setStatusFormat:HTTPSTunnelingString, [proxyLocation hostname], proxyPort, [[aURL parsedNetLocation] hostname]];

	// Which port?
	portString = [[aURL parsedNetLocation] port];
	realPort = (portString != nil) ? [portString intValue] : [[self class] defaultPort];

	// Build CONNECT-String	
	connectString = [NSMutableString stringWithFormat:@"CONNECT %@:%d HTTP/1.0\r\n%@", 
		[[aURL parsedNetLocation] hostname], realPort, [self userAgentHeaderStringForURL:aURL]];

	// Need Authorization?
	if ([self authorizationStringForURL:aURL] != nil)
		[connectString appendString:[self authorizationStringForURL:aURL]];

	// And an empty line for the end
	[connectString appendString:@"\r\n"];

	// Start tunneling
	[socketStream writeString:connectString];

	if ([[OFUserDefaults sharedUserDefaults] boolForKey:HTTPSDebugLog])
		NSLog(@"SSLTunneling->ConnectString: [%@]", connectString);

	while(YES)
	{
		returnString = [socketStream peekLine];

		if ([[OFUserDefaults sharedUserDefaults] boolForKey:HTTPSDebugLog])
			NSLog(@"SSLTunneling->ReturnString: [%@]", returnString);

		if ([returnString length] <= 0 || fConnect)
		{
			returnString = [socketStream readLine];
			if ([returnString length] <= 0)
				break; // Empty line

			continue; // Read the stuff behind the "200 CONNECTION" Message 
		}

		if (![returnString hasPrefix:@"HTTP/"])
		{
			returnString = [socketStream readLine];
			continue;
		}
	
		// Connect successful
		if ([returnString containsString:@" 200 "])
		{
			fConnect = YES;
			returnString = [socketStream readLine];
			// Read until the empty line
			continue;
		}
		
		// Other response then 200, maybe an error or proxy authorization?
		break;	// OWHTTPProcessor should handle this
	}
	
	return fConnect;
}

- (BOOL)_prepareHTTPSConnectionForProcessor:(HTTPSProcessor *)aProcessor
{
	BOOL	fConnected = YES;

	[aProcessor setStatusFormat:HTTPSStatusString, [[(OWAddress *)[[aProcessor pipeline] lastAddress] url] netLocation]];

	if (_connectingViaProxyTunneling)
		fConnected = [self _tunnelConnectForProcessor:aProcessor];

	if (fConnected)
	{
		[(SSLSocket *)[socketStream socket] sslConnect];
		[self _connectionInfos:aProcessor];

		if (![[OFUserDefaults sharedUserDefaults] boolForKey:HTTPSCacheEnabled])
			[[aProcessor pipeline] disableContentCache];
	}

	return fConnected;
}

- initWithAddress:(OWAddress *)anAddress inQueue:(OWHTTPSessionQueue *)aQueue
{
	if ((self = [super initWithAddress:anAddress inQueue:aQueue]) == nil)
		return nil;

	_connectingViaProxyTunneling = flags.connectingViaProxyServer;
	flags.connectingViaProxyServer = NO; // Tunneling is different from using a "Proxy-Server"
	
	return self;
}

- (ONSocketStream *)socketStream
{
	return socketStream;
}

- (OWAddress *)address
{
	return address;
}

- (BOOL)sendRequests
{
    NSData			*requestData;
    NSString		*requestString;
    OWAddress		*anAddress;
    HTTPSProcessor	*aProcessor = nil;
    unsigned int index, count;

    // figure out how many requests to send
    flags.pipeliningRequests = [queue shouldPipelineRequests];
    count = [processorQueue count];
    // We've already sent requests for the processors in processorQueue
    index = count;
    if (flags.pipeliningRequests) {
        unsigned int maximumNumberOfRequestsToPipeline;

        maximumNumberOfRequestsToPipeline = [queue maximumNumberOfRequestsToPipeline];
        // Fill our queue
        while (count < maximumNumberOfRequestsToPipeline) {
            aProcessor = (HTTPSProcessor *)[queue nextProcessor];
            if (!aProcessor)
                break;
            [processorQueue addObject:aProcessor];
            count++;
        }
    } else {
        if (count == 0) {
            if ((aProcessor = (HTTPSProcessor *)[queue nextProcessor])) {
                [processorQueue addObject:aProcessor];
                count++;
            }
        } else {
            // We still have pipelined requests, but don't want to pipeline any more (presumably because the server cannot handle pipelined requests reliably).
            flags.pipeliningRequests = YES;
        }
    }

    // send each
    for (; index < count; index++) 
	{
		aProcessor = [processorQueue objectAtIndex:index];

		if ([self _prepareHTTPSConnectionForProcessor:aProcessor])
		{
			anAddress = (OWAddress *)[[aProcessor pipeline] lastAddress];
			requestString = [self requestStringForProcessor:aProcessor];
			if ([[OFUserDefaults sharedUserDefaults] boolForKey:@"OWHTTPDebug"])
				NSLog(@"%@ Tx: %@", [[anAddress url] scheme], requestString);
			[socketStream writeString:requestString];
			if ((requestData = [[anAddress methodDictionary] objectForKey:@"Content-Data"]))
				[socketStream writeData:requestData];
		}
    }
    return (index != 0);
}

//
// - sendRequest in OWHTTPSession ignores exceptions (why??). 
//
- (BOOL)sendRequest
{    
	if (![(ONInternetSocket *)[socketStream socket] isWritable]) 
	{
		[self disconnect];
		[self connect];
	}

	[self sendRequests];

	return ([processorQueue count] != 0);
}

- (BOOL)fetchForProcessor:(HTTPSProcessor *)aProcessor inPipeline:(OWPipeline *)aPipeline
{
	BOOL	fFlag;
	
	[aProcessor setNonretainedHTTPSSession:self];
	fFlag = [super fetchForProcessor:aProcessor inPipeline:aPipeline];
	[aProcessor setNonretainedHTTPSSession:nil];

	return fFlag;
}

@end

DEFINE_NSSTRING(HTTPSSessionUserAbortExceptionName);
