//************************************************************************
//
//	HTTPSProcessor.m
//
//	by Juergen Moellenhoff <jm@oic.de>		
//
//
//	This code is supplied "as is" the author makes no warranty as to its 
//	suitability for any purpose.  This code is free and may be distributed 
//	in accordance with the terms of the:
//		
//			GNU GENERAL PUBLIC LICENSE
//			Version 2, June 1991
//			copyright (C) 1989, 1991 Free Software Foundation, Inc.
// 			675 Mass Ave, Cambridge, MA 02139, USA
//
//************************************************************************

#import "HTTPSProcessor.h"
#import "HTTPSSessionQueue.h"
#import "HTTPSSession.h"
#import "SSLSocket.h"
#import "HTTPSUtilities.h"

#import	<Foundation/NSBundle.h>
#import	<OmniBase/rcsid.h>
#import <OWF/OWF.h>
#import <OmniNetworking/ONSocketStream.h>

RCS_ID("$Header: /LocalDeveloper/CVS/HTTPS/HTTPSProcessor.m,v 1.18 1999/06/22 15:14:05 jurgen Exp $")

@implementation HTTPSProcessor

static	NSString	*HTTPSModifiedStatusString = nil;

+ (void)initialize 
{
	static BOOL fInitialized = NO;

	[super initialize];
	if (fInitialized)
		return;
    fInitialized = YES;

	HTTPSModifiedStatusString = [NSLocalizedStringFromTableInBundle(@"HTTPSModifiedStatusString", nil, CLASS_BUNDLE, @"Modified Status string.") retain];
}

+ (void)didLoad
{
    [self registerProcessorClass:self fromContentType:[OWURL contentTypeForScheme:@"https"] toContentType:[OWSourceProcessor sourceContentType] cost:1.0];
}

- initWithPipeline:(OWPipeline *)aPipeline
{
	if ((self = [super initWithPipeline:aPipeline]) == nil)
		return nil;

	_nonretainedHTTPSSession = nil;

	return self;
}

- (void)startProcessing
{
    [self startProcessingInHTTPSessionQueue:[HTTPSSessionQueue httpSessionQueueForAddress:(OWAddress *)[pipeline lastContent]]];
}

- (void)setNonretainedHTTPSSession:(HTTPSSession *)theSession
{
	_nonretainedHTTPSSession = theSession;
}

- (HTTPSSession *)nonretainedHTTPSSession
{
	return [[_nonretainedHTTPSSession retain] autorelease];
}

- (void)setStatusString:(NSString *)newStatusString
{
	if (_nonretainedHTTPSSession != nil)
	{
		SSLSocket	*sslSocket = (SSLSocket *)[[_nonretainedHTTPSSession socketStream] socket];

		if ([sslSocket isSecureConnection])
		{
			newStatusString = [NSString stringWithFormat:HTTPSModifiedStatusString, 
				newStatusString, [sslSocket protocolString], [sslSocket bits]];
		}
	}

	[super setStatusString:newStatusString];
}

@end
