//************************************************************************
//
//	HTTPSInformation.h
//
//	by Juergen Moellenhoff <jm@oic.de>		
//
//
//	This code is supplied "as is" the author makes no warranty as to its 
//	suitability for any purpose.  This code is free and may be distributed 
//	in accordance with the terms of the:
//		
//			GNU GENERAL PUBLIC LICENSE
//			Version 2, June 1991
//			copyright (C) 1989, 1991 Free Software Foundation, Inc.
// 			675 Mass Ave, Cambridge, MA 02139, USA
//
//************************************************************************

#import <OmniFoundation/OFObject.h>

#import <AppKit/NSNibDeclarations.h>

@class	HTTPSSession;
@class	HTTPSProcessor;
@class	NSPanel;
@class	NSScrollView;
@class	NSString;

@interface HTTPSInformation : OFObject
{
@public
IBOutlet	NSPanel				*panel;
IBOutlet	NSScrollView		*scrollView;

@private
	NSString	*_infoFormatString;
	BOOL		_canceled;
	BOOL		_disablePanel;
}

+ (HTTPSInformation *)sharedHTTPSInformation;

- (IBAction)ok:sender;
- (IBAction)cancel:sender;

- (IBAction)disablePanel:sender;

- (BOOL)runModalWithSession:(HTTPSSession *)session andProcessor:(HTTPSProcessor *)aProcessor;
- (BOOL)canceled;
- (BOOL)disablePanel;

@end
