//************************************************************************
//
//	HTTPSFunctions.m
//
//	by Juergen Moellenhoff <jm@oic.de>		
//
//
//	This code is supplied "as is" the author makes no warranty as to its 
//	suitability for any purpose.  This code is free and may be distributed 
//	in accordance with the terms of the:
//		
//			GNU GENERAL PUBLIC LICENSE
//			Version 2, June 1991
//			copyright (C) 1989, 1991 Free Software Foundation, Inc.
// 			675 Mass Ave, Cambridge, MA 02139, USA
//
//************************************************************************

#import	"HTTPSFunctions.h"

#import <stdio.h>

#import <OpenSSL/ssl.h>
#import <OpenSSL/err.h>

#import	<OmniBase/OmniBase.h>
#import <OmniBase/system.h>


RCS_ID("$Header: /LocalDeveloper/CVS/HTTPS/HTTPSFunctions.m,v 1.10 1999/06/22 15:14:05 jurgen Exp $")

NSString *sslErrorString(void)
{
	BIO 		*memBio;
	char		*buffer;
	long		length;
	NSString	*tempString;

	memBio = BIO_new(BIO_s_mem());
	ERR_print_errors(memBio);
	if ((length = BIO_ctrl(memBio, BIO_CTRL_INFO, 0, (char *)&buffer)) > 0)
		tempString = [NSString stringWithCString:buffer length:length];
	else
		tempString = @"Unknown error";
	BIO_free(memBio);

	return [NSString stringWithFormat:@"%@, Errno:%s", tempString, strerror(OMNI_ERRNO())];
}
