/*
    File:       JustTabItController.h

    Contains:	Header file for the tab view controller.

    Written by: Michelle Wyner

    Created:    October 1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):
	 	March 1998 - HI changes - DG
		October 1997 - file created.

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>
#import "HockeyData.h"

@interface JustTabItController : NSObject
{
  NSTabView *tabView; // the actual tab view
  id newTeamTextField; 
  id gameDisplayButtons; // buttons on the add new team window.
  id okButton;
  id addNewTeamWindow;
}

- (void)awakeFromNib;

- (void)tabView:(NSTabView *)tabView willSelectTabViewItem:(NSTabViewItem *)tabViewItem;

- (void)setUpNewTab:(NSString *)labelName simpleTab:(BOOL)flag;
- (void)addTab:(id)sender;
- (void)removeTab:(id)sender;

- (void)cancelNewTeamAdd:(id)sender;

@end
