/*
    File:       HockeyData.h

    Contains:	Header file for HockeyData
 
    Written by: Michelle Wyner

    Created:    October 1997

    Copyright:  (c)1997 by Apple Computer, Inc., all rights reserved.

    Change History (most recent first):
 		March 1998 - HI changes - DG
		October 1997 - file created.

    You may incorporate this sample code into your applications without
    restriction, though the sample code has been provided "AS IS" and the
    responsibility for its operation is 100% yours.  However, what you are
    not permitted to do is to redistribute the source as "DSC Sample Code"
    after having made changes. If you're going to re-distribute the source,
    we require that you make it clear in the source that the code was
    descended from Apple Sample Code, but that you've made changes.
*/

#import <AppKit/AppKit.h>

@interface HockeyData : NSObject
{
    id transactionView;
    NSWindow *tempWindow;
    NSWindow *tempWindow2;
    id	*dateField;
    id	*againstField;
    id 	*scoreField;
    id	*timeField;
    id	*wonLostButtons;
       
    NSMutableArray *array;
    id value;
    BOOL _loaded;
    BOOL _isSimple;

    NSView *view;
}

- (id)initWithSimpleTab:(BOOL)flag;
- (void)dealloc;

- (void)addRow:(id)sender;
- (void)removeRow:(id)sender;

- (int)numberOfRowsInTableView:(NSTableView *)theTableView;
- (void)update;
- (void)generateTestData;

- (void)tableView:(NSTableView *)tv setObjectValue:(id)object forTableColumn:(NSTableColumn *)tableColumn row:(int)row;
- (SEL)setAccessorFromIdentifier:(NSString *)identifier;

- (BOOL)isLoaded;

- (NSView *)view;
- (NSView *)initialFirstResponder;

@end
