
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */


#import <AppKit/AppKit.h>
#import "macxglut_private.h"
#import "GLUTWindow.h"






/* *** GLUT window class *** */


@interface GLUTWindow(GLUTPrivate)

+ (void)initialize;


		/* menu support */
- (BOOL)validateMenuItem: (id<NSMenuItem>)menuItem;
- (IBAction)save: (id)sender;
- (IBAction)saveAs: (id)sender;
- (IBAction)copy: (id)sender;

		/* services support */
- (id)validRequestorForSendType:(NSString *)sendType returnType:(NSString *)returnType;
- (BOOL)writeSelectionToPasteboard:(NSPasteboard *)pboard types:(NSArray *)types;

		/* misc */
- (NSRect)_frameRectForProposedRect: (NSRect)rect;
- (void)_writeToFile: (NSString *)path;
- (NSBitmapImageRep *)_bitmapImageRepWithTIFFInsideContentView;
#if defined(INTERCEPTOR_HATES_EPS)
- (NSData *)_dataWithEPSInsideContentView;
#endif
- (NSData *)_dataWithRTFDInsideContentView;

- (void)makeKeyAndOrderFront: (id)sender;
- (BOOL)canBecomeKeyWindow;

@end
