
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTWindow.h"
#import "GLUTWindow_Private.h"
#import "GLUTView.h"
#import "GLUTView_Private.h"
#import "GLUTApplication.h"










/* ***************** GLUTWindow class implementation ******************** */


@implementation GLUTWindow


	/* designated initializer for top-level windows */
- (id)initWithTitle: (NSString *)title displayString: (const char *)dstring gameMode: (BOOL)isGameMode
{
	unsigned int	windowStyle;
	
	if(isGameMode == NO)
		windowStyle = (NSTitledWindowMask | NSMiniaturizableWindowMask | NSResizableWindowMask);
	else
		windowStyle = NSBorderlessWindowMask;
	
	if((self = [super initWithContentRect: NSMakeRect(0.0, 0.0, 100.0, 100.0)
							styleMask: windowStyle backing: NSBackingStoreRetained defer: NO]) != nil)
	{
		NSRect	winRect;
				
		if(isGameMode == NO)
		{
			winRect = NSMakeRect((float) __glutInitX, (float) __glutInitY, (float) __glutInitWidth, (float) __glutInitHeight);
			winRect = [self _frameRectForProposedRect: winRect];
		}
		else
		{
			winRect = [[NSScreen mainScreen] frame];
			[self setLevel: NSScreenSaverWindowLevel - 1];
		}
		[self setFrame: winRect display: NO];
		[self setTitle: title];
		[self setReleasedWhenClosed: NO];
		[self setMinSize: NSMakeSize(80.0, 80.0)];
			
			/* create and configure content view */
		_view = [[GLUTView allocWithZone: [self zone]] initWithFrame: NSMakeRect(0.0, 0.0, 10.0, 10.0) displayString: dstring isSubWindow: NO];
		if(_view == nil)
			goto _failed;
		
		[_view setFrame: [NSWindow contentRectForFrameRect: winRect styleMask: [self styleMask]]];
		[self setContentView: _view];
		[self makeFirstResponder: _view];
		[self setDelegate: _view];
		if(isGameMode == NO)
		{
			[self setMiniwindowTitle: title];
//			if(__glutIconic)
//				_flags.pendingIconify = YES;
		}
		
			/* init rest of state */
		_flags.pendingShowHide	= YES;
		_flags.doShowOp			= YES;		
		[self setNeedsStateUpdate: YES];
		
		return self;
	}

_failed:
	
	[self release];
	return nil;
}

- (void)dealloc
{	
		/* remove ourselves from the window list */
	NSMapRemove(__glutWindowList, (void *) _windowKey);
	if(self == __glutCurrentWindow)
		__glutCurrentWindow = nil;
	
	[_imagePath release];	
	[super dealloc];
}



- (GLUTVisual *)visual
{
	return [_view visual];
}

- (GLUTOverlay *)overlay
{
	return [_view overlay];
}

	/* Return window position either in screen or parent coordinates. */
- (NSPoint)windowPositionRelativeToParent: (BOOL)yesno
{
	return _positionInXWindowsCoords;
}

	/* Return window size in local coordinates. */
- (NSSize)windowSize
{
	return [_view frame].size;
}

- (BOOL)isSubWindow
{
	return NO;
}

- (BOOL)isDamaged
{
	return [_view isDamaged];
}

- (id <GLUTWindows>)parentWindow
{
	return nil;
}

- (int)numberOfSubWindows
{
	NSArray *	subviews = [_view subviews];
	
	return (subviews != nil) ? (int) [subviews count] : 0;
}

- (NSWindow *)nativeWindow
{
	return self;
}

- (void)setWindowKey: (int)key
{
	_windowKey = key;
}

	/* Adds the given view to the subview hierarchy of the receiver. */
- (void)addSubWindow: (id <GLUTWindows>)subwindow
{
	[_view addSubview: subwindow];
}

	/* Makes the receiver the current window */
- (void)makeCurrent
{
	[_view makeCurrent];
}

- (void)makeNotCurrent
{
	[_view makeNotCurrent];
}

- (void)swapBuffers
{
	[_view swapBuffers];
}

- (void)setIconTitle: (NSString *)title
{
	[self setMiniwindowTitle: title];
}


		/* *** event handlers *** */


- (void)setKeyboardCallback: (GLUTKeyboardCallback)func isKeyDown: (BOOL)yesno
{
	[_view setKeyboardCallback: func isKeyDown: yesno];
}

- (void)setMouseCallback: (GLUTMouseCallback)func
{
	[_view setMouseCallback: func];
}

- (void)setMotionCallback: (GLUTMotionCallback)func
{
	[_view setMotionCallback: func];
}

- (void)setPassiveMotionCallback: (GLUTMotionCallback)func
{
	[_view setPassiveMotionCallback: func];
}
 
- (void)setEntryCallback: (GLUTEntryCallback)func
{
	[_view setEntryCallback: func];}

- (void)setSpecialCallback: (GLUTSpecialCallback)func isKeyDown: (BOOL)yesno
{
	[_view setSpecialCallback: func isKeyDown: yesno];
}

- (int)modifierFlags
{
	return 	[_view modifierFlags];
}

- (void)setDisplayCallback: (GLUTDisplayCallback)func
{
	[_view setDisplayCallback: func];
}

- (void)setReshapeCallback: (GLUTReshapeCallback)func
{
	[_view setReshapeCallback: func];
}

- (void)setWindowStatusCallback: (GLUTWindowStatusCallback)func
{
	[_view setWindowStatusCallback: func];
}

- (void)setVisibilityCallback: (GLUTVisibilityCallback)func
{
	[_view setVisibilityCallback: func];
}

- (void)setSpaceballMotionCallback: (GLUTSpaceballMotionCallback)func
{
	[_view setSpaceballMotionCallback: func];
}

- (void)setSpaceballRotateCallback: (GLUTSpaceballRotateCallback)func
{
	[_view setSpaceballRotateCallback: func];
}

- (void)setSpaceballButtonCallback: (GLUTSpaceballButtonCallback)func
{
	[_view setSpaceballButtonCallback: func];
}

- (void)setButtonBoxCallback: (GLUTButtonBoxCallback)func
{
	[_view setButtonBoxCallback: func];
}

- (void)setDialCallback: (GLUTDialCallback)func
{
	[_view setDialCallback: func];
}

- (void)setTabletMotionCallback: (GLUTTabletMotionCallback)func
{
	[_view setTabletMotionCallback: func];
}

- (void)setTabletButtonCallback: (GLUTTabletButtonCallback)func
{
	[_view setTabletButtonCallback: func];
}

- (void)setJoystickCallback: (GLUTJoystickCallback)func pollInterval: (NSTimeInterval)delay
{
	[_view setJoystickCallback: func pollInterval: delay];
}

- (BOOL)ignoreKeyRepeats
{
	return [_view ignoreKeyRepeats];
}

- (void)setIgnoreKeyRepeats: (BOOL)yesno
{
	[_view setIgnoreKeyRepeats: yesno];
}

- (NSTimeInterval)joystickPollInterval
{
	return [_view joystickPollInterval];
}

- (int)cursor
{
	return [_view cursor];
}

	/* Sets the receiver's cursor. if "cursor" is equal nil no cursor should be visible. */
- (void)setCursor: (int)cursor
{
	[_view setCursor: cursor];
}

- (void)setNeedsStateUpdate: (BOOL)yesno
{
	[_view setNeedsStateUpdate: yesno];
}

- (BOOL)needsStateUpdate
{
	return [_view needsStateUpdate];
}

	/* Marks the current window as needing redisplay. */
- (void)postRedisplay
{
	[_view postRedisplay];
}

	/* Sets the position of the receiver. */
- (void)setPosition: (NSPoint)origin
{
	_flags.pendingMove = YES;
	_pos = _positionInXWindowsCoords = origin;
	_pos.y = (float) __glutScreenHeight - _pos.y;
	if(_flags.pendingReshape == NO)
		_pos.y -= [_view frame].size.height;
	else
		_pos.y -= _size.height;
	[_view setNeedsStateUpdate: YES];
}

	/* Sets the receivers size */
- (void)setSize: (NSSize)size
{
	_flags.pendingReshape = YES;
	_size = size;
	[_view setNeedsStateUpdate: YES];
}

	/* Makes the window cover the whole screen */
- (void)setToFullScreen
{
	_flags.pendingFullScreen = YES;
	[_view setNeedsStateUpdate: YES];
}

	/* Moves the receiver to the top of all it's siblings. */
- (void)push
{
	_flags.pendingPushPop = YES;
	_flags.doPushOp = YES;
	[_view setNeedsStateUpdate: YES];
}

	/* Moves the receiver to the bottom of all it's siblings. */
- (void)pop
{
	_flags.pendingPushPop = YES;
	_flags.doPushOp = NO;
	[_view setNeedsStateUpdate: YES];
}

	/* Makes the receiver visible. */
- (void)show
{
	[_view show];
	_flags.pendingShowHide = YES;
	_flags.doShowOp = YES;
}

	/* Makes the receiver invisible. */
- (void)hide
{
	[_view hide];
	_flags.pendingShowHide = YES;
	_flags.doShowOp = NO;
}

	/* If the receiver is a top-level window it gets iconified. */
- (void)iconify
{
	_flags.pendingIconify = YES;
	[_view setNeedsStateUpdate: YES];
}

	/* creates/replaces the window's overlay plane */
- (void)establishOverlay
{
	[_view establishOverlay];
}

	/* Sets the layer to use if the receiver will be made current. */
- (void)setUsesLayer: (GLenum)layer
{
	[_view setUsesLayer: layer];
}

	/* If the receiver has currently an overlay established, it is removed. */
- (void)removeOverlay
{
	[_view removeOverlay];
}

	/* Sends an update message to all views which are currently on the update list of the receiving window
		and updates the state of the window itself as needed. */
- (void)updateWindowState
{
	[_view setNeedsStateUpdate: NO];

		/* ** fullscreen handling ** */
	if(_flags.pendingFullScreen == YES)
	{
		NSRect	winRect;
		
		winRect = [[NSScreen mainScreen] visibleFrame];
		[self setFrame: winRect display: YES];
		_flags.pendingFullScreen = NO;
		_flags.pendingReshape = NO;
		_flags.pendingIconify = NO;
	}
	
		/* ** iconify handling ** */
	if(_flags.pendingIconify == YES)
	{
		[self performMiniaturize: self];
		_flags.pendingIconify = NO;
		_flags.pendingFullScreen = NO;
		_flags.pendingMove = NO;
		_flags.pendingReshape = NO;
	}
	
		/* ** reshape handling ** */
	if(_flags.pendingReshape == YES)
	{
		[self setContentSize: _size];
		_flags.pendingReshape = NO;
		_flags.pendingFullScreen = NO;
	}
	
		/* ** move handling ** */
	if(_flags.pendingMove == YES)
	{
		NSPoint	origin = _pos;
		
		[self setFrameOrigin: origin];
		_flags.pendingMove = NO;
	}
			
		/* ** show/hide handling ** */
	if(_flags.pendingShowHide == YES)
	{
		if(_flags.doShowOp == YES)
		{
				/* show */
			if([self isMiniaturized] == NO)
				[self makeKeyAndOrderFront: nil];
			else
			{
				[self deminiaturize: nil];
				[self makeKeyAndOrderFront: nil];
			}
		}
		else
		{
				/* hide */
			[self orderOut: nil];
		}
		_flags.pendingShowHide = NO;
	}
	
		/* ** push/pop handling ** */
	if(_flags.pendingPushPop == YES)
	{
		if(_flags.doPushOp == YES)
			[self makeKeyAndOrderFront: nil];
		else
			[self orderBack: nil];
		_flags.pendingPushPop = NO;
	}
	
	[_view updateWindowState];
}

- (void)updateWindowStatus: (int)status
{
	[_view updateWindowStatus: status];
}

- (int)determineWindowStatusIgnoringSiblings: (BOOL)ignoreSiblings
{
	return [_view determineWindowStatusIgnoringSiblings: ignoreSiblings];
}

- (int)windowStatus
{
	return [_view windowStatus];
}

	/* Returns a data object containing the current contents of the receiving window */
- (NSData *)contentsAsDataOfType: (NSString *)pboardType
{
	if([pboardType isEqualToString: NSTIFFPboardType] == YES)
	{
		return [[self _bitmapImageRepWithTIFFInsideContentView] TIFFRepresentation];
	}
	else if([pboardType isEqualToString: NSPostScriptPboardType] == YES)
	{
#if defined(INTERCEPTOR_HATES_EPS)
			/* Interceptor and EPS generation does obviously not go together */
		return [self _dataWithEPSInsideContentView];
#else
		return [self dataWithEPSInsideRect: [_view frame]];
#endif
	}
	else if([pboardType isEqualToString: NSRTFDPboardType] == YES)
	{
		return [self _dataWithRTFDInsideContentView];
	}
	
	return nil;
}

@end
