
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTOverlay.h"
#import "GLUTView.h"
#import "GLUTVisual.h"



static GLUTCriterion	_requiredOverlayCriteria[] =
{
	{DS_LEVEL, DS_EQ, 1},       /* This entry gets poked in determineOverlayVisual. */
	{DS_TRANSPARENT, DS_EQ, 1},
	{DS_XPSEUDOCOLOR, DS_EQ, 1},
	{DS_RGBA, DS_EQ, 0},
	{DS_BUFFER_SIZE, DS_GTE, 1}
};
static int				_numRequiredOverlayCriteria = sizeof(_requiredOverlayCriteria) / sizeof(GLUTCriterion);
static int				_requiredOverlayCriteriaMask = (1 << DS_LEVEL) | (1 << DS_TRANSPARENT) | (1 << DS_XSTATICGRAY) | (1 << DS_RGBA) | (1 << DS_CI_MODE);









/* ***************** GLUTOverlay class implementation ******************** */


@implementation GLUTOverlay

+ (BOOL)canCreateInstanceWithString: (const char *)dstring
{
	return [GLUTVisual	canCreateInstanceWithString: dstring
								requiredCriteria: _requiredOverlayCriteria
								count: _numRequiredOverlayCriteria
								requiredCriteriaMask: _requiredOverlayCriteriaMask];
}


- (id)initWithFrame: (NSRect)frame view: (GLUTView *)view
{
	if((self = [super init]) != nil)
	{
		_view	= view;
		_visual = [[GLUTVisual allocWithZone: [self zone]]	initWithString: __glutDisplayString
																			pixelsWide: (int) frame.size.width
																			pixelsHigh: (int) frame.size.height
																			requiredCriteria: _requiredOverlayCriteria
																			count: _numRequiredOverlayCriteria
																			requiredCriteriaMask: _requiredOverlayCriteriaMask];
		if(_visual == nil)
			goto _failed;
		
		return self;
	}

_failed:
	
	[self release];
	return nil;
}

- (void)dealloc
{
	[_visual release];
	
	[super dealloc];
}

- (GLUTVisual *)visual
{
	return _visual;
}

	/* Returns the current size of the overlay plane in pixels */
- (NSSize)size
{
	return [_visual size];
}

	/* Sets the overlay plane to the given size in pixels */
- (void)setSize: (NSSize)newSize
{
	[_visual setSize: newSize];
}

	/* Makes the receiver the current GL visual */
- (void)makeCurrent
{
	[_visual makeCurrent];
}

- (void)makeNotCurrent
{
	[_visual makeNotCurrent];
}

- (void)displayInRect: (NSRect)rect
{
	if(_displayCallback != NULL && [_view isVisible] == YES && _damagedByUser == YES)
	{
		[_visual makeCurrent];
			[self drawRect: rect];
			if(__glutDebug)
				glutReportErrors();
			_damagedByUser = NO;
		[_visual makeNotCurrent];
	}
}

	/* composits the contents of the overlay plane into the given view. */
- (void)drawRect: (NSRect)rect
{
	(*_displayCallback)();
	glFlush();
}

- (void)setDisplayCallback: (GLUTDisplayCallback)func
{
	_displayCallback = func;
}

- (void)show
{
	_isVisible = YES;
	_damagedByUser = YES;
	[_view displayRectIgnoringOpacity: [_view bounds]];
}

- (void)hide
{
	_isVisible = NO;
	_damagedByUser = YES;
	[_view setNeedsDisplayInRect: [_view bounds]];
}

- (void)display
{
	_damagedByUser = YES;
}

- (void)update
{
	[self drawRect: [_view bounds]];
	_damagedByUser = NO;
}

@end
