
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#if defined(GFXLIB_MESA26)

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTMesaVisual.h"




@interface GLUTMesaVisual(GLUTPrivate)

- (void)_createBackBuffer;
- (void)_freeBackBuffer;

@end







	/* *** GLUTMesaVisual class implementation *** */


@implementation GLUTMesaVisual

	/* Return an array of visual info structures, where each one describes one of the supported
		frame buffer configurations, possible with the receiving visual. */
+ (const GLUTVisualInfo *)makeVisualInfos: (int *)nummodes
{
#define	NUM_VISUAL_INFOS	2

	GLUTVisualInfo *	vi = NULL, *savedvi;
	
	vi = (GLUTVisualInfo *) NSZoneMalloc([self zone], sizeof(GLUTVisualInfo) * NUM_VISUAL_INFOS);
	if(vi == NULL) return NULL;
	
	savedvi = vi;
	*nummodes = NUM_VISUAL_INFOS;
	
		/* all, alpha */
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 16;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 8;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// all, no alpha
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 16;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;

	return (const GLUTVisualInfo *) savedvi;

#undef	NUM_VISUAL_INFOS
}




- (id)initWithString: (const char *)displayString pixelsWide: (int)width pixelsHigh: (int)height requiredCriteria: (const GLUTCriterion *)crits count: (unsigned int)critscount requiredCriteriaMask: (int)mask
{
	if((self = [super initWithString: displayString pixelsWide: width
							pixelsHigh: height requiredCriteria: crits
							count: critscount requiredCriteriaMask: mask]) != nil)
	{
		const GLUTVisualInfo *		visualInfo = NULL;
		BOOL								treatAsSingle;
		
		NS_DURING
		{		
			if((visualInfo = [[self class] visualInfoFromString: displayString
						treatAsSingle: &treatAsSingle
						requiredCriteria: crits
						count: critscount
						requiredCriteriaMask: mask]) == NULL)
			{
				__glutFatalError("display mode not supported.");
			}
			
			[self setVisualInfo: visualInfo];
			[self _createBackBuffer];
			
			_ctx = OSMesaCreateContext(OSMESA_RGBA, NULL);
			if(_ctx == NULL)
				[NSException raise: NSMallocException format: @""];
			
			OSMesaMakeCurrent(_ctx, NULL, GL_UNSIGNED_BYTE, 0, 0);
			NS_VALUERETURN(self, id);
		}
		
		NS_HANDLER
		{
			[self release];
			NS_VALUERETURN(nil, id);
		}
		NS_ENDHANDLER
	}

	return nil;
}

- (void)dealloc
{
	if(_ctx)
	{
		[self makeNotCurrent];
		OSMesaDestroyContext(_ctx);
	}
	[self _freeBackBuffer];
	
	[super dealloc];
}

	/* Sets the overlay plane to the given size in pixels */
- (void)setSize: (NSSize)newSize
{
	const GLUTVisualInfo *		vi = [self visualInfo];
	NSBitmapImageRep *			newImage = nil;
	int								spp = 3, bps = 0, bpp = 4;
	BOOL								hasAlpha = NO;
	
	[super setSize: newSize];
	
	if(vi->cap[DS_ALPHA_SIZE] > 0)
	{
		spp		= 4;
		hasAlpha	= YES;
	}
	bps = vi->cap[DS_RED_SIZE];
	
	if(_isBoundToImageData == YES)
		OSMesaMakeCurrent(_ctx, NULL, GL_UNSIGNED_BYTE, 0, 0);

	[_image release];
	_imageData = NSZoneRealloc([self zone], _imageData, (int) newSize.width * (int) newSize.height * bpp);
	
	newImage = [[NSBitmapImageRep allocWithZone: [self zone]]	initWithBitmapDataPlanes: &_imageData
																					pixelsWide: (int) newSize.width
																					pixelsHigh: (int) newSize.height
																					bitsPerSample: bps
																					samplesPerPixel: spp
																					hasAlpha: hasAlpha
																					isPlanar: NO
																					colorSpaceName: NSDeviceRGBColorSpace
																					bytesPerRow: (int) newSize.width * bpp
																					bitsPerPixel: bps * bpp];
	_image = newImage;
	if(_isBoundToImageData == YES)
		OSMesaMakeCurrent(_ctx, _imageData, GL_UNSIGNED_BYTE, (GLsizei) newSize.width, (GLsizei) newSize.height);
}

	/* Makes the receiver the current OpenGL context in town. */
- (void)makeCurrent
{
	OSMesaMakeCurrent(_ctx, _imageData, GL_UNSIGNED_BYTE, (GLsizei) [self pixelsWide], (GLsizei) [self pixelsHigh]);
	_isBoundToImageData = YES;
}

	/* Makes the receiver not the current GL context. */
- (void)makeNotCurrent
{
	glFinish();
	OSMesaMakeCurrent(_ctx, NULL, GL_UNSIGNED_BYTE, 0, 0);
	_isBoundToImageData = NO;
}

	/* Swaps the contents of the back buffer to the front buffer */
- (void)swapBuffers
{
	glFinish();
	[_image draw];
}

@end


@implementation GLUTMesaVisual(GLUTPrivate)

- (void)_createBackBuffer
{
	const GLUTVisualInfo *	vi = [self visualInfo];
	int							spp = 3, bps = 0, bpp = 0;
	int							width = [self pixelsWide], height = [self pixelsHigh];
	BOOL							hasAlpha = NO;
	
	if(vi->cap[DS_ALPHA_SIZE] > 0)
	{
		spp		= 4;
		hasAlpha	= YES;
	}
	bps = vi->cap[DS_RED_SIZE];
	bpp = 4;
	
	_imageData = NSZoneMalloc([self zone], width * height * bpp);
	_image = [[NSBitmapImageRep allocWithZone: [self zone]]	initWithBitmapDataPlanes: &_imageData
																				pixelsWide: width
																				pixelsHigh: height
																				bitsPerSample: bps
																				samplesPerPixel: spp
																				hasAlpha: hasAlpha
																				isPlanar: NO
																				colorSpaceName: NSDeviceRGBColorSpace
																				bytesPerRow: width * bpp
																				bitsPerPixel: bps * bpp];
}

- (void)_freeBackBuffer
{
	if(_image)
	{
		[_image release];
		_image = nil;
	}
	if(_imageData)
	{
		NSZoneFree([self zone], _imageData);
		_imageData = NULL;
	}
}

@end

#endif
