
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#if defined(GFXLIB_CONIX)

#import "glut.h"
#import "macxglut_private.h"
#import "GLUTConixVisual.h"
#import <OpenGL/OpenGL.h>



static void	_buildAttribListFromVisualInfo(const GLUTVisualInfo *vi, GLint *list);


#ifndef MAX
#define MAX(x, y)		((x) > (y)) ? (x) : (y)
#endif






	/* *** GLUTConixVisual class implementation *** */


@implementation GLUTConixVisual


	/* Return an array of visual info structures, where each one describes one of the supported
		frame buffer configurations, possible with the receiving visual. */
+ (const GLUTVisualInfo *)makeVisualInfos: (int *)nummodes
{
#define	NUM_VISUAL_INFOS	32

	GLUTVisualInfo *	vi = NULL, *savedvi = NULL;
	
	vi = (GLUTVisualInfo *) NSZoneMalloc([self zone], sizeof(GLUTVisualInfo) * NUM_VISUAL_INFOS);
	if(vi == NULL) return NULL;
	
	savedvi = vi;
	*nummodes = NUM_VISUAL_INFOS;
	
		// vi 0
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 8;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 1
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 2
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 8;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 3
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// no depth buffer
		// vi 4
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 8;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 5
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 6
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 8;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 7
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
		
		// single buffered
		// vi 8
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 8;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 9
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 10
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 8;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 11
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// no depth buffer
		// vi 12
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 8;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 13
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 14
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 8;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 15
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 8;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	
		/* ** no alpha ** */
	
		// vi 16
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 17
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 18
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 19
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// no depth buffer
		// vi 20
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 21
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 22
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 23
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 1;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
		
		// single buffered
		// vi 24
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 25
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 26
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 27
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 32;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// no depth buffer
		// vi 28
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 29
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 8;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 30
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 8;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 8;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 8;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	vi++;
	
		// vi 31
	vi->valid = 1;
	vi->cap[DS_RGBA] = 1;
	vi->cap[DS_BUFFER_SIZE] = 0;
	vi->cap[DS_DOUBLEBUFFER] = 0;
	vi->cap[DS_STEREO] = 0;
	vi->cap[DS_AUX_BUFFERS] = 0;
	vi->cap[DS_RED_SIZE] = 8;
	vi->cap[DS_GREEN_SIZE] = 8;
	vi->cap[DS_BLUE_SIZE] = 8;
	vi->cap[DS_ALPHA_SIZE] = 0;
	vi->cap[DS_DEPTH_SIZE] = 0;
	vi->cap[DS_STENCIL_SIZE] = 0;
	vi->cap[DS_ACCUM_RED_SIZE] = 0;
	vi->cap[DS_ACCUM_GREEN_SIZE] = 0;
	vi->cap[DS_ACCUM_BLUE_SIZE] = 0;
	vi->cap[DS_ACCUM_ALPHA_SIZE] = 0;
	vi->cap[DS_LEVEL] = 0;
	vi->cap[DS_XVISUAL] = 0;
	vi->cap[DS_TRANSPARENT] = 0;
	vi->cap[DS_SAMPLES] = 0;
	vi->cap[DS_XSTATICGRAY] = 0;
	vi->cap[DS_XGRAYSCALE] = 0;
	vi->cap[DS_XSTATICCOLOR] = 0;
	vi->cap[DS_XPSEUDOCOLOR] = 0;
	vi->cap[DS_XTRUECOLOR] = 1;
	vi->cap[DS_XDIRECTCOLOR] = 0;
	vi->cap[DS_SLOW] = 0;
	vi->cap[DS_CONFORMANT] = 1;
	
	return (const GLUTVisualInfo *) savedvi;

#undef	NUM_VISUAL_INFOS
}




- (id)initWithString: (const char *)displayString pixelsWide: (int)width pixelsHigh: (int)height requiredCriteria: (const GLUTCriterion *)crits count: (unsigned int)critscount requiredCriteriaMask: (int)mask
{
	if((self = [super initWithString: displayString pixelsWide: width pixelsHigh: height
							requiredCriteria: crits count: critscount requiredCriteriaMask: mask]) != nil)
	{
		const GLUTVisualInfo *	visualInfo = NULL;
		GLRPixelFormat *			pixelFormat = nil;
		GLint							atts[128];

		NS_DURING
		{		
			if((visualInfo = [[self class] visualInfoFromString: displayString
						treatAsSingle: &_treatAsSingle
						requiredCriteria: crits
						count: critscount
						requiredCriteriaMask: mask]) == NULL)
			{
				__glutFatalError("display mode not supported.");
			}
			
			[self setVisualInfo: visualInfo];
			
			_buildAttribListFromVisualInfo(visualInfo, atts);
			pixelFormat = [GLRPixelFormat chooseWithScreen: [NSScreen mainScreen] attribs: atts];
			if(pixelFormat == nil)
				[NSException raise: NSMallocException format: @""];
		
			_ctx = [[GLRContext allocWithZone: [self zone]] initWithFormat: pixelFormat share: nil];
			if(_ctx == NULL)
				[NSException raise: NSMallocException format: @""];
			
			NS_VALUERETURN(self, id);
		}
		
		NS_HANDLER
		{
			[self release];
			NS_VALUERETURN(nil, id);
		}
		NS_ENDHANDLER
	}

	return nil;
}

- (void)dealloc
{
	if(_ctx)
	{
		[self makeNotCurrent];
		[_ctx release];
	}
	
	[super dealloc];
}

	/* Returns YES if the visual is in reality a double buffered visual, but should be treated as a single buffered one. */
- (BOOL)treatAsSingle
{
	return _treatAsSingle;
}

	/* Makes the receiver the current OpenGL context in town. */
- (void)makeCurrent
{
	[_ctx setDrawable: [__glutCurrentWindow nativeWindow]];
	[_ctx makeCurrent];
	if(_treatAsSingle == YES)
		glDrawBuffer(GL_FRONT);
}

	/* Makes the receiver not the current GL context. */
- (void)makeNotCurrent
{
	glFinish();
	[_ctx makeNotCurrent];
	[_ctx setDrawable: nil];
}

	/* Swaps the contents of the back buffer to the front buffer */
- (void)swapBuffers
{
	if(_treatAsSingle ==  NO)
		[_ctx swapBuffers];
	else
		glFlush();
}


/* *** private functions *** */

static void _buildAttribListFromVisualInfo(const GLUTVisualInfo *vi, GLint *list)
{
	GLint i = 0;
	
	if(vi->cap[DS_DOUBLEBUFFER])
		list[i++] = GLR_DOUBLEBUFFER;
	
	if(vi->cap[DS_STEREO])
		list[i++] = GLR_STEREO;
	
	if(vi->cap[DS_RGBA] == 0)
	{
		list[i++] = GLR_BUFFER_SIZE;
		list[i++] = vi->cap[DS_BUFFER_SIZE] >> 3;
	}
	else
	{
		list[i++] = GLR_RGBA;
		list[i++] = GLR_RED_SIZE;
		list[i++] = vi->cap[DS_RED_SIZE] >> 3;
		list[i++] = GLR_GREEN_SIZE;
		list[i++] = vi->cap[DS_GREEN_SIZE] >> 3;
		list[i++] = GLR_BLUE_SIZE;
		list[i++] = vi->cap[DS_BLUE_SIZE] >> 3;
		if(vi->cap[DS_ALPHA_SIZE] > 0)
		{
			list[i++] = GLR_ALPHA_SIZE;
			list[i++] = vi->cap[DS_ALPHA_SIZE] >> 3;
		}
		if(vi->cap[DS_ACCUM_RED_SIZE] > 0)
		{
			list[i++] = GLR_ACCUM_RED_SIZE;
			list[i++] = vi->cap[DS_ACCUM_RED_SIZE] >> 3;
			list[i++] = GLR_ACCUM_GREEN_SIZE;
			list[i++] = vi->cap[DS_ACCUM_GREEN_SIZE] >> 3;
			list[i++] = GLR_ACCUM_BLUE_SIZE;
			list[i++] = vi->cap[DS_ACCUM_BLUE_SIZE] >> 3;
			if(vi->cap[DS_ACCUM_ALPHA_SIZE] > 0)
			{
				list[i++] = GLR_ACCUM_ALPHA_SIZE;
				list[i++] = vi->cap[DS_ACCUM_ALPHA_SIZE] >> 3;
			}
		}
	}
	
	if(vi->cap[DS_DEPTH_SIZE] > 0)
	{
		list[i++] = GLR_DEPTH_SIZE;
		list[i++] = vi->cap[DS_DEPTH_SIZE] >> 4;
	}
	
	if(vi->cap[DS_STENCIL_SIZE] > 0)
	{
		list[i++] = GLR_STENCIL_SIZE;
		list[i++] = vi->cap[DS_STENCIL_SIZE] >> 3;
	}
	
	if(vi->cap[DS_AUX_BUFFERS] > 0)
	{
		list[i++] = GLR_AUX_BUFFERS;
		list[i++] = vi->cap[DS_AUX_BUFFERS];
	}
	
	if(vi->cap[DS_LEVEL] > 0)
	{
		list[i++] = GLR_LEVEL;
		list[i++] = vi->cap[DS_LEVEL];
	}
	
	list[i++] = GLR_MINIMUM_POLICY;
	list[i++] = GLR_CLOSEST_POLICY;
	
	list[i] = GLR_NONE;
}

@end

#endif
