
/* Copyright (c) Planitzer Dietmar, 1998. */

/* This program is freely distributable without licensing fees
   and is provided without guarantee or warrantee expressed or
   implied. This program is -not- in the public domain. */

#import "GLUTClipboardController.h"
#import "macxglut_private.h"
#import "GLUTApplication.h"
#import <SoundKit/Sound.h>
#import <SoundKit/SoundView.h>











/* *** class implementation *** */

@implementation GLUTClipboardController

/* ** class methods ** */


/* ** instance methods ** */

- (id)init
{
	if((self = [super initWithWindowNibName: @"GLUTClipboard"]) != nil)
	{
		[self setShouldCascadeWindows: NO];
		_lastChangeCount	= 0;
		_firstTime			= YES;
		
		return self;
	}
	return nil;
}

- (void)dealloc
{	
	[super dealloc];
}


- (void)windowDidLoad
{
	[((NSPanel *) [self window]) setBecomesKeyOnlyIfNeeded: YES];
}


	/* ******* Actions ******** */


- (IBAction)toggleWindow:(id)sender
{
	NSWindow *	window = [self window];
	
	if([self isClipboardWindowVisible] == NO)
	{
			/* if contents on pasteboard changed, update our document view */
		if((_firstTime == YES) || (_lastChangeCount != [[NSPasteboard generalPasteboard] changeCount]))
		{
			[self updateClipboardWindow];
			_firstTime = NO;
		}
		
		[window center];
		[super showWindow:sender];
	}
	else
	{
		[window performClose: nil];
	}
}

- (BOOL)validateMenuItem:(NSMenuItem *)anItem
{
	if([self isClipboardWindowVisible] == YES)
		[anItem setTitle: FWLocalizedString(@"Hide Clipboard")];
	else
		[anItem setTitle: FWLocalizedString(@"Show Clipboard")];

	return YES;
}


	/* ******* UI ******* */


- (BOOL)isClipboardWindowVisible
{
	if([self isWindowLoaded] == YES)
		return ([self window] && [[self window] isVisible]);
	else
		return NO;
}

	/* Creates and returns an autoreleased view representing the current contents on the pasteboard. */
- (void)updateClipboardWindow
{
	NSPasteboard *	pboard = [NSPasteboard generalPasteboard];
	NSString *		type = nil;
	NSString *		objectInfoString = nil;
	
		/* look for text contents */
	type = [pboard availableTypeFromArray: [NSArray arrayWithObjects: NSRTFDPboardType, NSRTFPboardType, NSStringPboardType, nil]];
	if(type)
	{
		NSTextView *	myTextView = [[NSTextView alloc] initWithFrame: NSMakeRect(0.0, 0.0, 1.0, 1.0)];

		[myTextView setHorizontallyResizable: YES];
		[myTextView setVerticallyResizable: YES];
		[myTextView setImportsGraphics: YES];
		[myTextView selectAll: nil];
		[myTextView paste: nil];

		if([type isEqualToString: NSRTFDPboardType] == YES)
		{
				/* RTFD */
			objectInfoString = [NSString stringWithString: FWLocalizedString(@"Rich Text of type RTFD")];
		}
		else if([type isEqualToString: NSRTFPboardType])
		{
				/* RTF */
			objectInfoString = [NSString stringWithString: FWLocalizedString(@"Rich Text of type RTF")];
		}
		else
		{
				/* Plain test */
			objectInfoString = [NSString stringWithString: FWLocalizedString(@"Plain Text")];
		}
		
		[myTextView setEditable: NO];
		[myTextView setSelectable: NO];
		[myTextView setUsesFontPanel: NO];
		
		[_scrollView setDocumentView: myTextView];
		[myTextView release];
		goto _finishUpdate;
	}
		
		/* look for picture contents */
	type = [pboard availableTypeFromArray: [NSImage imagePasteboardTypes]];
	if(type)
	{
		NSImage *		myImage = [[NSImage alloc] initWithPasteboard: pboard];
		NSSize			imageSize = [myImage size];
		NSImageView *	myImageView = nil;
		
		myImageView = [[NSImageView alloc] initWithFrame: NSMakeRect(0.0, 0.0, imageSize.width, imageSize.height)];
		
		[myImageView setImage: myImage];
		[myImageView setEditable: NO];
		[myImageView setImageAlignment: NSImageAlignCenter];
		
		[myImage release];
		
		[_scrollView setDocumentView: myImageView];
		[myImageView scrollPoint: NSMakePoint(0.0, [myImageView bounds].size.height)];
		[myImageView release];
		
		objectInfoString = [NSString stringWithFormat: FWLocalizedString(@"Picture of type %@"), type];
		goto _finishUpdate;
	}
	
		/* look for a sound contents */
	type = [pboard availableTypeFromArray: [NSArray arrayWithObjects: NXSoundPboardType, nil]];
	if(type)
	{
		Sound *		mySound = [[Sound alloc] initFromPasteboard: pboard];
		SoundView *	mySoundView = [[SoundView alloc] initWithFrame: NSMakeRect(0.0, 0.0, 470, 140)];
		
		[mySoundView setSound: mySound];
		
		[mySoundView setEditable: NO];
		[mySoundView setEnabled: YES];
		[mySoundView sizeToFit];
		
//		[mySound release];
		
		[_scrollView setDocumentView: mySoundView];
		[mySoundView release];
		
		objectInfoString = [NSString stringWithFormat: FWLocalizedString(@"Sound of type %@"), type];		
		goto _finishUpdate;
	}
	
		/* there is an unknown type of data on the pasteboard */
	if(type)
	{
		objectInfoString = [NSString stringWithString: FWLocalizedString(@"Unknown contents")];
		goto _finishUpdate;
	}
		
		/* there is nothing on the pasteboard */
	objectInfoString = [NSString stringWithString: FWLocalizedString(@"Empty")];
	
_finishUpdate:
	
	[_infoText setStringValue: [NSString stringWithFormat: FWLocalizedString(@"Clipboard contents: %@."), objectInfoString]];
}

@end
