
/* Copyright (c) Dietmar Planitzer, 1998 */

/* This program is freely distributable without licensing fees 
   and is provided without guarantee or warrantee expressed or 
   implied. This program is -not- in the public domain. */

#import <AppKit/AppKit.h>



/* *** GLUT application class *** */


@interface GLUTApplication : NSApplication
{
@private
	
	NSMutableArray *			_windowsNeedingUpdate;
	BOOL							_windowsNeedUpdate;
}


- (id)init;

- (NSEvent *)nextEventMatchingMask:(unsigned int)mask untilDate:(NSDate *)expiration inMode:(NSString *)mode dequeue:(BOOL)deqFlag;

- (void)timerAction;
- (void)periodicAction:(id)unused;
- (void)menuDidSendAction: (NSNotification *)notification;
- (void)menuWillSendAction: (NSNotification *)notification;

- (void)markWindowAsNeedingUpdate: (id<GLUTWindows>)window;
- (void)unmarkWindowAsNeedingUpdate: (id<GLUTWindows>)aWindow;
- (BOOL)updateWindowStatesIfNeeded;

- (void)applicationDidFinishLaunching:(NSNotification *)notification;
- (void)applicationWillTerminate:(NSNotification *)notification;

@end
