#import  "WaitMessageCtr.h"
#import  <AppKit/NSOpenPanel.h>
#import  <Foundation/NSDate.h>
#import  <Foundation/NSArray.h>
#import  <Foundation/NSThread.h>
#import  <Foundation/NSLock.h>
#import  <Foundation/NSConnection.h>
#import  <Foundation/NSAutoreleasePool.h>
#import  "PercentView.h"
#import  "IntervalTimer.h"

/* extern */ WaitMessageCtr *theWaitMsg = NULL;

@implementation WaitMessageCtr

- messageDisplay:(NSString *)msg
{
	if (msg) {
		[messagePanel makeKeyAndOrderFront:self];
		[messageText setStringValue:msg];
		[messagePanel setFloatingPanel:YES];
		// [messagePanel setAutodisplay:NO];
		[messagePanel display];
		PSWait();
	}else {
		[progressView reset:self];
		[messagePanel setFloatingPanel:NO];
		[messagePanel close];
	}
	return self;
}

- (void)setStringValue:(NSString *)aString
{
	[self messageDisplay: aString];
}

- (void)resetProgress
{
	[timer stopThread];
	[progressView reset:self];
	PSWait();
	[messagePanel display];
}

- (void)setProgress:(int)whole
{
	aswhole = (float)whole;
	if (timer == nil)
		timer = [[IntervalTimer alloc] init];
	[timer startThread];
}

- (void)progress:(int)value
{
	if ([timer check]) {
		[progressView setFloatValue: (float)value/aswhole];
		PSWait();
		[progressView display];
	}
}

@end
