#import <AppKit/NSApplication.h>
#import <AppKit/NSControl.h>
#import <AppKit/NSTextField.h>
#import <AppKit/NSScrollView.h>
#import <AppKit/NSPanel.h>
#import <AppKit/NSGraphics.h>
#import <AppKit/NSImage.h>
#import <Foundation/NSBundle.h>	/* LocalizedString */
#import "NSStringAppended.h"
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import "ToyWin.h"
#import "ToyView.h"
#import "TVController.h"
#import "PrefControl.h"
#import "WaitMessageCtr.h"
#import "strfunc.h"

#define MiniIcon @"miniwin.tiff"
#define  DiffStep	18.0
#define  MinWinXSIZE	120.0
#define  MinWinYSIZE	32.0
#define  MinResizeXSIZE	200.0
#define  MinResizeYSIZE	150.0


@implementation ToyWin

/* extern */ BOOL displayOverKeyWindowFlag = NO;
/* Local */
static id	theMiniIcon = nil;
static NSSize	screenSize;

+ (void)initialize
{
	screenSize = [[NSScreen mainScreen] frame].size;
	theMiniIcon = [NSImage imageNamed:MiniIcon];
}

+ (BOOL)displayOverKeyWindow:(BOOL)flag
{
	BOOL old = displayOverKeyWindowFlag;
	displayOverKeyWindowFlag = flag;
	return old;
}

- init
{
	parental = nil;
	operation = 0;
	scaleFactor = 1.0;
	imageFilename = nil;
	miniFlag = mini_YET;
	makeMapOnly = NO;
	return self;
}

- init: parent by:(int)op
{
	[self init];
	[NSBundle loadNibNamed:@"ToyWin.nib" owner:self];
	[thiswindow setReleasedWhenClosed:YES];
	[thiswindow setMiniwindowImage: theMiniIcon];
	parental = parent;
	operation = op;
	return self;
}

- initMapOnly
{
	/* An instance of ToyWin initialized by this method does not
		display a window.  It is used to make the bitmap of
		a image file to support pasteboard service. */
	[self init];
	makeMapOnly = YES;
	return self;
}

- (void)dealloc
{
	id	tv;

	if (imageFilename) [imageFilename release];
	if (scalePanel) [scalePanel release];
	if (scView && (tv = [scView documentView]) != nil)
		[tv release];
	[super dealloc];
}

- (NSString *)filename
{
	return imageFilename;
}

- (void)resetFilename:(NSString *)fileName
{
	if (imageFilename) [imageFilename release];
	imageFilename = fileName;
	[imageFilename retain];
	[thiswindow setTitleWithRepresentedFilename:imageFilename]; 
}

- (NSWindow *)window
{
	return thiswindow;
}

- toyView
{
	return [scView documentView];
}

- parent
{
	return parental;
}

- (int)madeby
{
	return operation;
}

/* ----------------------------------------------------------------
ɥ

    ɽ
	礭˹碌롣
	꡼礭ϥ꡼
	⤵Ʊ͡
	ޤ(MinWinXSIZE=120, MinWinYSIZE=32)꾮
	ϤͤȤ
    ɽ
	atpointΰ֤ɽNULLʤ饦ɥֹˤäƷꡣ
	꡼礭Ϻü
	꡼⤬礭Ͼü
    ꥵκ祵
	Τ礭˹碌롣
	ʺΤȤ꡼礭ǲ뤳ȤϤʤ
    ꥵκǾ
	(MinResizeXSIZE=200, MinResizeYSIZE=150)Ȥ롣
	ϲ˹碌롣
᡼Υꥵ
    ɽ
	礭ʤäѲʤ
	ʤäǡΥɥǤ礭Ͼε§
	ˤäѲ롣
    ɽ
	Ѳʤ
    ꥵκ硦Ǿ
	ΥΡ֥ꥵκǾפ꾮
	ǾȤ롣
	ʳϾ̤ꡣ
---------------------------------------------------------------- */

#define  loc_INIT	0	/* Window is initialized */
#define  loc_RESZ	1	/* Window is resized */
#define  loc_SPEC	2	/* Window is initialized */
				/* and displayed at specified point */

/* Local Method */
- locateWindow: (int)width : (int)height by:(int)is_init : (NSPoint *)atpoint;
	/* width, height  ᡼礭 */
{
	NSSize req;	/* ᡼ݤɽǤ礭 */
	NSSize rsmin;	/* ꥵκǾ */
	NSRect orig;	/* ߤΥɥξ */
	NSRect wrect;
	double xp, yp;	/* ɥ */
	static int winCounter = 6; /* because small window is under the menu */

#ifdef __APPLE__
	req.width = ((MinWinXSIZE > width) ? MinWinXSIZE : width) + 30.0;
	req.height = ((MinWinYSIZE > height) ? MinWinYSIZE : height) + 68.0;
#else
	req.width = ((MinWinXSIZE > width) ? MinWinXSIZE : width) + 23.0;
	req.height = ((MinWinYSIZE > height) ? MinWinYSIZE : height) + 74.0;
#endif
	rsmin.width = (req.width < MinResizeXSIZE)
			? req.width : MinResizeXSIZE;
	rsmin.height = (req.height < MinResizeYSIZE)
			? req.height : MinResizeYSIZE;
	wrect.size = req;

	if (is_init == loc_RESZ) {
		orig = [thiswindow frame];
		wrect.origin = orig.origin;
		if (req.width > orig.size.width)
			wrect.size.width = orig.size.width;
		if (req.height >= orig.size.height)
			wrect.size.height = orig.size.height;
		else
			wrect.origin.y += orig.size.height - wrect.size.height;
		if (orig.size.width < rsmin.width)
			rsmin.width = orig.size.width;
		if (orig.size.height < rsmin.height)
			rsmin.height = orig.size.height;
	}else {
		NSSize scr = screenSize;
#ifndef __APPLE__
		scr.width -= 68.0;
#endif
		if (is_init == loc_INIT || atpoint == NULL) {
			int xm = 13, ym = 15;
			if (scr.height <= 600.0)
				xm = 7, ym = 9;
			xp = (req.width > scr.width)
				? 0.0 : (120.0 + (winCounter % xm) * DiffStep);
#ifdef __APPLE__
			yp = (req.height > scr.height)
				? 20.0 : (22.0 + (winCounter % ym) * DiffStep);
#else
			yp = (req.height > scr.height)
				? 0.0 : (20.0 + (winCounter % ym) * DiffStep);
#endif
		}else { /* loc_SPEC */
			double w;
			xp = atpoint->x;
			yp = scr.height - atpoint->y;
			if (xp < 0) xp = 0.0;
			else if (xp > (w = scr.width - MinResizeXSIZE))
				xp = w;
			if (yp < 0) yp = 0.0;
			else if (yp > (w = scr.height - MinResizeYSIZE))
				yp = w;
		}
		if (xp + req.width > scr.width)
			wrect.size.width = scr.width - xp;
		if (yp + req.height > scr.height)
			wrect.size.height = scr.height - yp;
		wrect.origin.x = xp;
		yp = scr.height - wrect.size.height - yp;
		wrect.origin.y = (yp > 0.0) ? yp : 0.0;
		winCounter++;
	}

	[thiswindow setFrame:wrect display:NO];
	[thiswindow setMaxSize:req];
	[thiswindow setMinSize:rsmin];
	return self;
}

/* Scroll image to be top & center */
- (void)scrollProperly
{
	NSSize imgsz;
	NSRect wrect;
	NSPoint scorig;
	int	xp, yp;
	id	tv;

	tv = [self toyView];
	imgsz = [[tv image] size];
	wrect = [scView documentVisibleRect];
	scorig.x = ((xp = imgsz.width - wrect.size.width) > 0) ? (xp / 2) : 0;
	scorig.y = ((yp = imgsz.height - wrect.size.height) > 0) ? yp : 0;
	if (xp > 0 || yp > 0)
		[tv scrollPoint:scorig]; 
}


#define  FilenameLimit	120

static void stripHistory(char *buf)
{
	int n, lx, rx;

	if ((n = strlen(buf)) < FilenameLimit || buf[n-1] != ')')
		return;
	for (rx = n-1; buf[rx] != '('; )
		if (--rx <= 0) return;
	for (lx = 0; buf[lx] != '('; )
		if (++lx >= n) return;
	if (lx == rx) return;
	if (lx > 0 && buf[lx-1] != '_')
		buf[lx++] = '_';
	while (lx <= n)
		buf[lx++] = buf[rx++];
}

- initLocateWindow:(NSString *)fileName width:(int)width height:(int)height 
{
	ToyWin *keytw;
	BOOL	hasKey;
	NSPoint point;
	NSRect	rect;
	char   *buf;

	buf = str_dup([fileName cStringInEUC]);
	stripHistory(buf);
	imageFilename = [NSString stringWithCStringInEUC:(const char *)buf];
	[imageFilename retain];
	free((void *)buf);
	keytw = [theController keyWindow];
	hasKey = (keytw != nil && keytw->miniFlag != mini_MINI);
	if (displayOverKeyWindowFlag) {
		if (hasKey) {
			rect = [[keytw window] frame];
			point = rect.origin;
			point.y += rect.size.height;
		}else {
			NSPoint pnt = [thePreference topLeftPoint];
			point.x = pnt.x;
			point.y = screenSize.height - pnt.y;
		}
		[self locateWindow: width : height by:loc_SPEC : &point];
	}else
		[self locateWindow: width : height by:loc_INIT : NULL];
	[thiswindow setTitleWithRepresentedFilename: imageFilename];
	if (hasKey)
		[thiswindow orderWindow:NSWindowBelow relativeTo:[[keytw window] windowNumber]];
	else
		[thiswindow orderFront:self];
	PSWait();
	[thiswindow display];
	return self;
}

/* Local */
- Do_reScale: (float)factor
{
	float r;
	NSSize sz;
	BOOL showmsg;

	r = (scaleFactor > factor)
		? (scaleFactor / factor):(factor / scaleFactor);
	if (r < 1.0025)
		return self;
	sz = [[self toyView] resize:factor];
	if (sz.width <= 0 || sz.height <= 0) {
		NSBeep();
		return self;
	}
	scaleFactor = factor;
	showmsg = (r > 1.7 || (sz.width * sz.height) > 60000);

	if (showmsg)
		[theWaitMsg messageDisplay:
			NSLocalizedString(@"Resizing...", Resizing)];
	[self locateWindow: sz.width : sz.height by:loc_RESZ : NULL];
	// DON'T -> [scView sizeTo: sz.width + 21.0 : sz.height + 21.0];
	[self scrollProperly];
	[thiswindow display];
	if (showmsg)
		[theWaitMsg messageDisplay:nil];
	return self;
}

/* Local */
- select_reScale: sender
{
	static float scale[13] = { 0.0, /* never */
		4.0, 3.0, 2.0, 1.5, 1.2, 1.0,
		0.86603, 0.7071, 0.5, 0.33333, 0.25, 0.125 };
#ifdef __APPLE__
	return [self Do_reScale: scale[[sender tag]]];
#else
	return [self Do_reScale: scale[[sender selectedTag]]];
#endif
}

/* Local */
- setScaleValue:(float)val
{
	NSString *str;
	int i = val * 100.0;
	int f = (val * 100.0 - (float)i) * 10.0 + 0.5;
	str = f ? [NSString stringWithFormat:@"%d.%01d", i, f]
		: [NSString stringWithFormat:@"%d", i];
	[scaleText setStringValue:str];
	return self;
}

- (void)reScale:sender
{
#ifdef __APPLE__
	if ([sender tag] == 0)
#else
	if ([sender selectedTag] == 0)
#endif
	{ /* Set... */
		[self setScaleValue: scaleFactor];
		[scalePanel makeKeyAndOrderFront:self];
		[scaleText selectText:self];
	}else {
		[scalePanel close];
		[NSObject cancelPreviousPerformRequestsWithTarget:self
			selector:@selector(select_reScale:) object:sender];
                [self performSelector:@selector(select_reScale:)
			withObject:sender afterDelay: 5 / 1000.0];
	} 
}

- (void)setScale:sender
{
	if ([sender selectedTag] == 0) {
		float f = (int)([scaleText floatValue] * 1000.0 + 0.5) / 100000.0;
		[scalePanel close];
		if (f >= 0.01 && f <= 100.0)
			[self Do_reScale: f];
	}else
		[scalePanel close]; 
}

- (void)windowDidMiniaturize:(NSNotification *)notification
{
	[[self toyView] clearDraggedLine];
	miniFlag = mini_MINI;
}

- (void)windowDidDeminiaturize:(NSNotification *)notification
{
	// NSWindow *theWindow = [notification object];
	miniFlag = mini_DEMINI;
}

- (BOOL)windowShouldClose:(id)sender
{
	// printf("Window will be freed\n");
	[theController checkWindow: self delete: YES];
	// [scView release];
	[thiswindow setDelegate:nil];
	[self release];
	return YES;
}

- (void)windowDidBecomeKey:(NSNotification *)notification
{
	id tv = [self toyView];
	[thiswindow makeFirstResponder:tv];
	[tv setDraggedLine:self];
}

- (void)windowDidExpose:(NSNotification *)notification
{
	[[self toyView] setDraggedLine:self];
}

- (void)windowDidMove:(NSNotification *)notification
{
	[[self toyView] setDraggedLine:self];
}

- (BOOL)hasCounterpart
{
	return (miniFlag != mini_YET);
}

@end
