#import "ToyView.h"
#import <AppKit/psopsOpenStep.h>
#import <AppKit/psopsNeXT.h>
#import <AppKit/NSEvent.h>
#import <AppKit/NSImage.h>
#import <AppKit/NSBitmapImageRep.h>
#import <AppKit/NSApplication.h>
#import <AppKit/NSCursor.h>
#import <Foundation/NSRunLoop.h>
#import <Foundation/NSData.h>
#import "NSStringAppended.h"
#import <AppKit/NSTextField.h>
#import <stdlib.h>
#import "PrefControl.h"

#define CrossCursor @"cross.tiff"

static NSCursor *xCursor = nil;
static BOOL originUpperLeft = NO;


@implementation ToyView (EventHandling)

+ cursor
{
    if (!xCursor) {
	NSPoint spot;
	spot.x = 7.0;
	spot.y = 7.0;
	xCursor = [NSCursor alloc];
#if 0	/* Not Implemented yet... */
        [xCursor initWithImage: [NSImage imageNamed:CrossCursor]];
	[xCursor setHotSpot:spot];
#else
	[xCursor initWithImage: [NSImage imageNamed:CrossCursor] hotSpot:spot];
#endif
	/* Don't release the object by "imageNamed:" */
    }
    return xCursor;
}

+ (BOOL)setOriginUpperLeft:(BOOL)flag
{
	BOOL oldflag = originUpperLeft;
	originUpperLeft = flag;
	return oldflag;
}

+ (void)setTransColorBlack:(BOOL)flag
{
	transBlack = flag;
}

- (BOOL)acceptsFirstResponder
{
	return YES;
}

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
	return NO;
}

- (void)resetCursorRects
{
	NSRect visible;

	if (!NSIsEmptyRect(visible = [self visibleRect]))
		[self addCursorRect:visible cursor:xCursor];
}

/* Local Method */
- drawDraggedLine: (float)x : (float)y : (int)dx : (int)dy
{
	char	buf[20];
	int	y1, y2;
	NSString *points;

	if (originUpperLeft) {
		y1 = curSize.height - y - dy;
		y2 = curSize.height - y - 1;
	}else {
		y1 = y,  y2 = y + dy - 1;
	}
	points = [NSString stringWithFormat:@"%d x %d  (%d, %d : %d, %d)",
			dx, dy, (int)x, y1, (int)x + dx - 1, y2];
	[commText setStringValue:points];

	// already 'lockFocus'ed
	PSnewinstance();
	PSsetinstance(YES);
	PSsetlinewidth(0.0);
	PSsetgray(0.1667);
	PSrectstroke(x, y+1, dx-1, dy-1);	/* Why +1 ?? */
	if ( dx >= 18 && dy >= 10 ) {
		sprintf(buf, "%d x %d", dx, dy);
		PSmoveto(x+1, y+2);
		PSselectfont("Times-Roman", 12.0);
		PSshow(buf);
	}
	PSsetinstance(NO);
	PSWait();
	return self;
}

- (void)clearDraggedLine
{
	NSSize *sz = &selectRect.size;
	if (sz->width > 0.0 || sz->height > 0.0) {
		[self lockFocus];
		PSnewinstance();
		[self unlockFocus];
		sz->width = 0.0;
		sz->height = 0.0;
		[self rewriteComment];
	} 
}

- (void)setDraggedLine:sender
{
	NSSize *sz = &selectRect.size;
	if (sz->width > 0.0 && sz->height > 0.0) {
		[self lockFocus];
		[self drawDraggedLine: selectRect.origin.x
			: selectRect.origin.y : sz->width : sz->height];
		[self unlockFocus];
	} 
}

- (void)rewriteComment
{
	[commText setStringValue:
		[NSString stringWithCStringInEUC:comInfo->memo]];
}

#define DRAG_MASK	(NSLeftMouseUpMask|NSLeftMouseDraggedMask)
#define PRESS_MASK	(NSLeftMouseUpMask|NSLeftMouseDownMask)

/* Local Method */
- mousePress: (int)count
{
	NSRect	rect;

	if (!comInfo->alpha)
		return self;
	if (transBlack && comInfo->type != Type_eps) {
		if (count <= 1) {
			if (backgray == 0.0) return self;
			backgray = 0.0;
		}else if (count > 3) backgray = 1.0;
		else backgray = (count - 1) / 3.0;
		// Double-click = Dark Gray,  Triple click = Gray Light
	}else {
		if (count <= 1) {
			if (backgray == 1.0) return self;
			backgray = 1.0;
		}else if (count > 3) backgray = 0.0;
		else backgray = (4 - count) / 3.0;
		// Double-click = Light Gray,  Triple click = Dark Gray
	}
	rect.origin.x = rect.origin.y = 0;
	rect.size = curSize;
	[self lockFocus];
	[self drawRect:rect];
	[self unlockFocus];
	[[self window] flushWindow];
	return self;
}

/* Code based on pCD.app (H. Danisch & D. Phillips) */

- (void)mouseDown:(NSEvent *)event 
{
	NSPoint	p, start, lowerleft;
	BOOL	altDrag = NO, sftDrag = NO;
	int	cn;
	int	xn = 0, yn = 0, xs, ys;

	[self mousePress: (cn = [event clickCount])];
	if (cn > 1) return;
	p = [event locationInWindow];
	p = [self convertPoint:p fromView:nil]; /* View based point */
	if (p.x < 0.0) p.x = 0.0;
	else if (p.x >= curSize.width) p.x = curSize.width - 1;
	p.y--;
	if (p.y < 0.0) p.y = 0.0;
	else if (p.y > curSize.height) p.y = curSize.height - 1;
	start.x = (int)p.x;
	start.y = (int)p.y;
	if (NSAlternateKeyMask & [event modifierFlags])
		altDrag = YES;

	[self lockFocus];
	PSnewinstance();
	PSsetinstance(YES);
	event = [[self window] nextEventMatchingMask:DRAG_MASK];

	while( [event type] != NSLeftMouseUp ) {
		if (NSAlternateKeyMask & [event modifierFlags])
			altDrag = YES;
		if (NSShiftKeyMask & [event modifierFlags])
			sftDrag = YES;
		[self autoscroll:event];
		p = [event locationInWindow];
		p = [self convertPoint:p fromView:nil];
		if (p.x < 0.0) p.x = 0.0;
		else if (p.x >= curSize.width) p.x = curSize.width - 1;
		p.y--;
		if (p.y < 0.0) p.y = 0.0;
		else if (p.y > curSize.height) p.y = curSize.height - 1;

		if (p.x > start.x)
			xn = (int)p.x - start.x + 1,  xs = 1;
		else
			xn = start.x - (int)p.x + 1,  xs = -1;
		if (p.y > start.y)
			yn = (int)p.y - start.y + 1,  ys = 1;
		else
			yn = start.y - (int)p.y + 1,  ys = -1;
		if (altDrag) {
			if (xn < yn) yn = xn;
			else xn = yn;
		}
		if (sftDrag) {
			xn = (xn + 1) & ~3;
			yn = (yn + 1) & ~3;
		}
		p.x = start.x + (xn-1)*xs;
		p.y = start.y + (yn-1)*ys;
		lowerleft.x = (start.x < p.x) ? start.x : p.x;
		lowerleft.y = (start.y < p.y) ? start.y : p.y;
		[self drawDraggedLine: lowerleft.x : lowerleft.y : xn : yn];
		event = [[self window] nextEventMatchingMask:DRAG_MASK];
	}
	[self unlockFocus];
	    
	selectRect.origin.x = lowerleft.x;
	selectRect.origin.y = lowerleft.y;
	selectRect.size.width  = xn;
	selectRect.size.height = yn;
	if (xn == 0 && yn == 0)		/* only click */
		[self rewriteComment];
	else if (xn < 3 && yn < 3)	/* Too small area */
		[self clearDraggedLine];

	[[self window] flushWindow];
}

- (void)selectAll:(id)sender
{
	[self clearDraggedLine];
	selectRect.size = curSize;
	selectRect.origin.x = selectRect.origin.y = 0.0;
	[self setDraggedLine:sender];
}

- (void)copy:(id)sender
{
	NSData	*st;
	NSBitmapImageRep *bm;
        NSArray	*types;
	id	pb = [NSPasteboard generalPasteboard];

	if (selectRect.size.width < 1.0 || selectRect.size.height < 1.0) {
		NSBeep();
		return;
	}

	//  note that "owner:" in the following can not be "self", or the
	//  id of anything else which might be freed inbetween "Copy"
	//  operations.
        types = [NSArray arrayWithObject:NSTIFFPboardType];
        [pb declareTypes: types owner:NSApp];

	[self lockFocus];
	bm = [[NSBitmapImageRep alloc] initWithFocusedViewRect:selectRect];
	[self unlockFocus];

	st = [bm TIFFRepresentation];
	[pb setData:st forType:NSTIFFPboardType];
	// [st release];
	[bm release];
}

- (void)drawRect:(NSRect)r
{
	NSSize *sz;

	if (comInfo->alpha) {
		PSsetgray(backgray);	
		NSRectFill(r);
		[image compositeToPoint:(r.origin) fromRect:r
				operation: NSCompositeSourceOver];
	}else
		[image compositeToPoint:(r.origin) fromRect:r
				operation:NSCompositeCopy];

	sz = &selectRect.size;
	if (sz->width > 0.0 && sz->height > 0.0) {
		[NSObject cancelPreviousPerformRequestsWithTarget:self
			selector:@selector(setDraggedLine:) object:self];
		[self performSelector:@selector(setDraggedLine:)
			withObject:self afterDelay: 30 / 1000.0];
	}
}

@end
