#import "ToyView.h"
#import <AppKit/psopsOpenStep.h>
#import <AppKit/NSImage.h>
#import <AppKit/NSBitmapImageRep.h>
#import <AppKit/NSApplication.h>
#import "NSStringAppended.h"
#import <stdlib.h>
#import "ColorSpaceCtrl.h"

#ifdef __APPLE__
# import <AppKit/NSPICTImageRep.h>
#endif

BOOL transBlack = NO;

@implementation ToyView

/* Local Method */
- setupInfo
{
	NSRect rect;
	NSImageRep *rep;
	int x;

	origSize = [image size];
	if (origSize.width == 0 || origSize.height == 0)
		return nil;	/* maybe Filter error */
	rawmap = NULL;
	[image setScalesWhenResized:YES];
	[image setDataRetained:YES];
	// [image setBackgroundColor: NX_COLORWHITE];
	rep = [image bestRepresentationForDevice:nil];
	if ((x = [rep pixelsWide]) != NSImageRepMatchesDevice
			&& x != origSize.width) {
		origSize.width = x;
		origSize.height = [rep pixelsHigh];
		[image setSize:origSize];
	}
	scaleFactor = 1.0;
	rect.size = curSize = origSize;
	rect.origin.x = rect.origin.y = 0;
	[self initWithFrame:rect];

	comInfo = (commonInfo *)malloc(sizeof(commonInfo));
	comInfo->width	= origSize.width;
	comInfo->height	= origSize.height;
	comInfo->bits	= [rep bitsPerSample];
	comInfo->numcolors = NSNumberOfColorComponents([rep colorSpaceName]); /* without alpha */
	comInfo->alpha	= [rep hasAlpha];
	if ( [rep isKindOfClass:[NSBitmapImageRep class]] ) {
		NSString *w;
		comInfo->xbytes	= [(NSBitmapImageRep *)rep bytesPerRow];
		w = [(NSBitmapImageRep *)rep colorSpaceName];
		comInfo->cspace	= [ColorSpaceCtrl colorSpaceID: w];
		comInfo->isplanar = [(NSBitmapImageRep *)rep isPlanar];
		comInfo->pixbits = [(NSBitmapImageRep *)rep bitsPerPixel];
		comInfo->type = Type_tiff;
		backgray = transBlack ? 0.0 : 1.0;	/* Transparent Color */
#ifdef __APPLE__
	}else if ( [rep isKindOfClass:[NSPICTImageRep class]] ) {
		comInfo->xbytes	= 0;
		//  comInfo->cspace	= 0;  DON'T CARE
		comInfo->alpha	= NO;
		comInfo->isplanar = YES;	/* maybe... */
		comInfo->pixbits = 0;		/* don't care */
		comInfo->type = Type_pict;
		backgray = 1.0;
#endif
	}else {	/* EPS */
		comInfo->xbytes	= 0;
		//  comInfo->cspace	= 0;  DON'T CARE
		comInfo->alpha	= YES;
		comInfo->isplanar = YES;	/* maybe... */
		comInfo->pixbits = 0;		/* don't care */
		comInfo->type = Type_eps;
		backgray = 1.0;
	}
	comInfo->palette = NULL;
	comInfo->palsteps = 0;
	comInfo->memo[0] = 0;

	selectRect.size.width = 0.0;
	selectRect.size.height = 0.0;

	return self;
}

- initWithContentsOfFile:(NSString *)filename
{
	if ((image = [[NSImage alloc] initByReferencingFile:filename]) == nil)
		return nil;
	[ToyView cursor];
	return [self setupInfo];
}

- initFromData:(NSData *)data
{
	if ((image = [[NSImage alloc] initWithData:data]) == nil)
		return nil;
	[ToyView cursor];
	return [self setupInfo];
}


- initDataPlanes:(unsigned char **)planes info:(commonInfo *)cinf
{
	NSRect frect;
	NSBitmapImageRep *imageRep;
	int spp;
        NSString *cs;

	frect.origin.x = frect.origin.y = 0;
	origSize.width  = cinf->width;
	origSize.height = cinf->height;
	frect.size = curSize = origSize;
	scaleFactor = 1.0;
	backgray = transBlack ? 0.0 : 1.0;	/* Transparent Color */
	rawmap = planes[0];
	comInfo = cinf;

	[self initWithFrame:frect];
	spp = cinf->numcolors;
	if (cinf->alpha) spp++;
        cs = [ColorSpaceCtrl colorSpaceName: cinf->cspace];
        imageRep = [[NSBitmapImageRep alloc]
		initWithBitmapDataPlanes:planes
		pixelsWide:cinf->width pixelsHigh:cinf->height
		bitsPerSample:cinf->bits samplesPerPixel:spp
		hasAlpha:cinf->alpha isPlanar:YES colorSpaceName:cs
		bytesPerRow:cinf->xbytes bitsPerPixel:cinf->bits];
	if (imageRep == nil)
		return nil;
	if ((image = [[NSImage alloc] initWithSize:origSize]) == nil) {
		[imageRep release];
		return nil;
	}
	[image setScalesWhenResized:YES];
	[image setDataRetained:YES];
	[image addRepresentation:imageRep];
	[imageRep release];	/* Because imageRep is retained by image */
	[ToyView cursor];
	return self;
}

- (void)setCommText:(NSTextField *)text
{
	commText = text; 
}

- (NSSize)originalSize
{
	return origSize;
}

- (NSSize)resize:(float)factor
{
	int wd = (int)(origSize.width * factor + 0.5);
	int ht = (int)(origSize.height * factor + 0.5);
	if (wd > MAXWidth || ht > MAXWidth || wd < 4 || ht < 4)
		return NSZeroSize;
	curSize.width = wd;
	curSize.height = ht;
	scaleFactor = factor;
	// backgray = (comInfo->type == Type_eps) ? 1.0
	//	: (transBlack ? 0.0 : 1.0);	/* Transparent Color */
	[self setFrameSize:curSize];
	[[self window] invalidateCursorRectsForView:self];
	[image setSize:curSize];
	[self clearDraggedLine];
	return curSize;
}

- (void)dealloc
{
	if (image != nil)
		[image release];
	if (rawmap) free((void *)rawmap);
	/* NXBitmapImageRep's Bug ??
		Method "initDataPlanes: planes ..." allocates inside
		an area of 20 bytes such as "unsigned char *planes[5]".
		This area is not freed and becomes a leak node.
	*/
	if (comInfo) {
		if (comInfo->palette) free((void *)comInfo->palette);
		free((void *)comInfo);
	}
	{ [super dealloc]; return; };
}

- (NSImage *)image
{
	return image;
}

- (commonInfo *)commonInfo
{
	return comInfo;
}

- (NSRect)selectedRect
{
	return selectRect;
}

- (NSRect)selectedScaledRect
{
	static NSRect rct;

	if (scaleFactor == 1.0) return selectRect;
	rct.size.width = (int)(selectRect.size.width / scaleFactor + 0.5);
	rct.size.height = (int)(selectRect.size.height / scaleFactor + 0.5);
	rct.origin.x = (int)(selectRect.origin.x / scaleFactor + 0.5);
	rct.origin.y = (int)(selectRect.origin.y / scaleFactor + 0.5);
	return rct;
}

- (float)scaleFactor
{
	return scaleFactor;
}

/* Overload */
- (void)beginPrologueBBox:(NSRect)boundingBox creationDate:(NSString *)dateCreated createdBy:(NSString *)anApplication fonts:(NSString *)fontNames forWhom:(NSString *)user pages:(int)numPages title:(NSString *)aTitle
{
/* Not to use the title of the window as %%Title: of EPS file. */

	char buf[MAXFILENAMELEN];
	const char *p;
	int i, cc;

	p = [aTitle cStringInEUC];
	if (!p)
		p = [[[self window] title] cStringInEUC];
	for (i = 0;  ; i++) {
		cc = p[i];
		if (cc == 0 || (cc > 0 && cc <= ' ')
		|| cc == '(' || cc == ')' ) break;
		buf[i] = cc;
	}
	buf[i] = 0;
	[super beginPrologueBBox:boundingBox creationDate:dateCreated
		createdBy:anApplication fonts:fontNames forWhom:user
		pages:numPages title:
			[NSString stringWithCStringInEUC:(const char *)buf]];
}

@end
