#import  "TVController.h"
#import <AppKit/dpsOpenStep.h>
#import <AppKit/NSDPSContext.h>	// for TimedEntry
#import  <AppKit/NSApplication.h>
#import  <AppKit/NSControl.h>
#import  <AppKit/NSMenuItem.h>
#import  <AppKit/NSWorkspace.h>
#import  <Foundation/NSUserDefaults.h>
#import  <stdio.h>
#import  <stdlib.h>
#import  <string.h>
#import  <objc/zone.h>
#import  <bsd/libc.h>
#import  <mach/mach_init.h>
#import  "PrefControl.h"
#import  "BundleLoader.h"
#import  "ToyWin.h"
#import  "ToyView.h"
#import  "ImageOpCtr.h"
#import  "ImageSave.h"
#import  "common.h"
#import  "strfunc.h"

#define	 MAXWindows	80

@implementation TVController (WindowManager)

static int winp = 0, showp = 0;
static ToyWin *wintab[MAXWindows];
static NSTimer *teNum;

- (BOOL)hasWindow
{
	return (winp > 0);
}

- (void)newWindow:(ToyWin *)win
{
	if (winp < MAXWindows)
		wintab[winp++] = win; 
}

- checkWindow: (ToyWin *)win delete:(BOOL)delflag;
{
	/* Return Value:  nil: No such window,  self: Success */
	int i, j;

	j = -1;
	for (i = 0; i < winp; i++)
		if (wintab[i] == win) {
			j = i;
			break;
		}
	if (j < 0) return nil;
	if (delflag) {
		--winp;
		for (i = j; i < winp; i++)
			wintab[i] = wintab[i + 1];
	}
	return self;
}

- (void)deleteAllWindow:sender
{
	int i, n;

	n = winp, winp = 0;
	for (i = 0; i < n; i++)
		[[wintab[i] window] performClose:sender]; 
}

/* Local Method */
- (void)wakeup
{
	if (showp >= winp) {
		[teNum invalidate];
		[teNum release];
		showp = 0;
	}else
		[[wintab[showp++] window] orderFront:self];
}

- (void)showAllWindow:sender
{
	if (winp <= 0) return;
	if (showp > 0) {
		[teNum invalidate];
		[teNum release];
		showp = 0;
	}else {
		float intv = [thePreference allWinDisplayInterval] / 1000.0;
		[[wintab[0] window] orderFront:sender];
		teNum = [NSTimer scheduledTimerWithTimeInterval:intv
				target:self selector:@selector(wakeup)
				userInfo:nil repeats:YES];
                [teNum retain];
		showp = 1;
	} 
}

/* Local Method */
- (int)keyWindowIndex
{
	int i;

	for (i = 0; i < winp; i++)
		if ([[wintab[i] window] isMainWindow])
			return i;
	return (winp > 0) ? (winp - 1) : (-1);
}

- keyWindow
{
	int i = [self keyWindowIndex];
	return (i >= 0) ? wintab[i] : nil;
}

- (void)showNextWindow:sender
{
	int i = [self keyWindowIndex];
	if (i < 0 || winp <= 0)
		return;
	if ([sender tag]) { /* Previous */
		if (--i < 0) i = winp - 1;
	}else { /* Next */
		if (++i >= winp) i = 0;
	}
	[[wintab[i] window] makeKeyAndOrderFront:sender];
}

- keyParentWindow:(int)op
{
	ToyWin *tw, *win;

	if ((tw = [self keyWindow]) == nil)
		return nil;
	if (op != NoOperation && [tw madeby] == op) {
		win = [tw parent];
		if (win && [self isOpenedID: win])
			return win;
	}
	return tw;
}

- (BOOL)isOpened:(NSString *)newfile
{
	int i;

	for (i = 0; i < winp; i++)
		if ([newfile isEqualToString:[wintab[i] filename]]) {
			[[wintab[i] window] makeKeyAndOrderFront:self];
			return YES;
		}
	return NO;
}

- (BOOL)isOpenedID: (ToyWin *)win
{
	int i;

	for (i = 0; i < winp; i++)
		if (wintab[i] == win)
			return YES;
	return NO;
}

/* NSMenuActionResponder Protocol */
- (BOOL)validateMenuItem:(NSMenuItem *)aMenuItem
{
	SEL act;

	if (aMenuItem == menuToFront || aMenuItem == menuClear)
		return hasBGW;
	act = [aMenuItem action];
	if (act == @selector(saveAs:) || act == @selector(deleteAllWindow:)
		|| act == @selector(showAllWindow:)
		|| act == @selector(showNextWindow:))
		return (winp > 0);
	return YES;
}


/****** Print *****************************/

- (void)print:(id)sender
{
	id	tw;

	if ((tw = [self keyWindow]) == nil)
		NSBeep();
	else
		[tw print:sender];
}

/****** SaveAs... *************************/

/* Local Method */
- allocImageSave
{
	return [[BundleLoader loadClass:b_ImageSave] alloc];
}

- (void)saveAs:sender
{
	ToyWin	*tw;
	id	imgsv;
	commonInfo	*cinf;
	NSString	*p;

	if ((tw = (ToyWin *)[self keyWindow]) == nil) {
		NSBeep();
		return;
	}
	imgsv = [[self allocImageSave] initWithWin: tw];

	switch ([sender tag]) {
	case 0: [imgsv saveAsTiff:sender];
		break;
	case 1: [imgsv saveAsEPS:sender];
		break;
	case 2: [imgsv saveAsType:Type_bmp];
		break;
	case 3:
		if ((p = [imgsv saveAsGif:nil]) != NULL) {
			[imgsv release];
			cinf = [[tw toyView] commonInfo];
			if (cinf->type == Type_eps)
				[imageOpCtr newBitmap:self];
			[imageOpCtr reduce:self];
			tw = (ToyWin *)[self keyWindow];
			imgsv = [[self allocImageSave] initWithWin: tw];
			(void)[imgsv saveAsGif:p];
		}
		break;
	case 4: [imgsv saveAsType:Type_jpg];
		break;
	case 5: [imgsv saveAsType:Type_jbg];
		break;
	case 6: [imgsv saveAsType:Type_ppm];
		break;
	case 7: [imgsv saveAsXBM:sender];
		break;
	case 8: [imgsv saveAsPng: sender];
		break;
	}
	[imgsv release]; 
}

/****** Info.Panel attraction *************************/

- (void)attraction:sender
{
	if ([sender state]) {
		sleep(1);
		[sender setState:0];
	}
}

#ifdef  ToyViewer2_5
- (void)attraction:sender
{
	NSRect	wrct, brct;
	NSPoint pnt[2];
	NSImage *img;
	id	ws, win;

	img = [sender image];
	brct = [sender frame];
	wrct = [(win = [sender window]) frame];
	pnt[0].x = wrct.origin.x + brct.origin.x + 4;
	pnt[0].y = wrct.origin.y + brct.origin.y + 4;
	wrct = [[NSApp applicationIconImage] frame];
	pnt[1].x = wrct.origin.x + 8;
	pnt[1].y = wrct.origin.y + 8;
	ws = [NSWorkspace sharedWorkspace];
	[win performClose:self];
	[ws slideImage:img from:pnt[0] to:pnt[1]];
	[NSThread sleepUntilDate:[NSDate dateWithTimeIntervalSinceNow:(1)]];
	[ws slideImage:img from:pnt[1] to:pnt[0]];
	[win makeKeyAndOrderFront:self]; 
}
#endif

@end
