#import <AppKit/NSApplication.h>
#import <AppKit/NSImage.h>
#import <AppKit/NSPasteboard.h>
#import <AppKit/NSErrors.h>
/* #import <AppKit/obsoleteListener.h> */
#import <AppKit/NSErrors.h>
#import <Foundation/NSData.h>
#import <Foundation/NSString.h>
#import "NSStringAppended.h"
#import <Foundation/NSFileManager.h>
/*  Debug ... #import <Foundation/NSAutoreleasePool.h>	*/
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import "TVController.h"
#import "ToyWin.h"
#import "AlertShower.h"
#import "strfunc.h"
#import "common.h"

/*  Program by T. Ogihara
    This code is based on:
	GIFFilter.m, Graphics Interchange Format (GIF) image filter service.
	Author: Michael McCulloch
*/

#define  ErrorImage	@"pberror.tiff"

@implementation TVController (PBService)

static NSMutableArray *pbarray = nil;
static NSMutableArray *nxarray = nil;

/* To provide service to NEXTSTEP applications */
static NSString *NXCreateFilenamePboardType(NSString *typs)
{
	NSString *nx = @"NXTypedFilenamePboardType:";
	return [nx stringByAppendingString: typs];
}

- (void)registerServiceTypes:(NSString **)typestrs withID:(short *)typeids num:(int)typenum
{
	int	i;

	pbarray = [[NSMutableArray arrayWithCapacity: typenum] retain];
	nxarray = [[NSMutableArray arrayWithCapacity: typenum] retain];
	for (i = 0; i < typenum; i++){
	    if (typeids[i] != Type_tiff && typeids[i] != Type_eps) {
		[pbarray addObject: NSCreateFilenamePboardType(typestrs[i])];
		[nxarray addObject: NXCreateFilenamePboardType(typestrs[i])];
		/* To provide service to NEXTSTEP applications */
	    }
	}
}


NSString *filename = nil;

- (void)convertToTIFF:(NSPasteboard *)pasteboard userData:(NSString *)userData error:(NSString **)errorMessage
{
	int	i;
	id	pp;
	NSString *currentType;
	const unsigned char *data;
	char fname[MAXFILENAMELEN];
	int dataLen = 0;

	/* Note that method "applicationDidFinishLaunching", therefore,
	  method "startSelf" is activated before this method */

	currentType = [pasteboard availableTypeFromArray: pbarray];
	if (!currentType) {
		int	x;
		currentType = [pasteboard availableTypeFromArray: nxarray];
		if (!currentType)
			goto ErrEXIT;
		x = [nxarray indexOfObject: currentType];
		currentType = [pbarray objectAtIndex: x];
	}
	[filename release];
	filename = nil;
	pp = [pasteboard propertyListForType: currentType];
	if ([pp isKindOfClass:[NSArray class]])
		pp = [pp objectAtIndex: 0];
	if ([pp isKindOfClass:[NSData class]]) {
		data = [pp bytes];
		dataLen = [pp length];
	}else if ([pp isKindOfClass:[NSString class]]) {
		data = [pp cStringInFS];
		dataLen = strlen(data);
	}else
		goto ErrEXIT;
	if (!data || dataLen <= 0)
		goto ErrEXIT;
	/* Get the first name of the file list... */
	for (i = 0; i < dataLen; i++) {
		if (data[i] == 0 || data[i] == '\t') {
			fname[i] = 0;
			break;
		}
		fname[i] = data[i];
	}

ErrEXIT:
	fname[dataLen] = 0;
	if (dataLen > 0)
		filename = [[NSString stringWithCStringInFS:fname] retain];
	/* if jump to ErrEXIT occured, dataLen == 0 */
	// Deallocate the file name list
	// [pasteboard deallocatePasteboardData:data length:dataLen];

	[pasteboard declareTypes:[NSArray arrayWithObject:NSTIFFPboardType]
		owner:self];
}

- (void)pasteboard:(NSPasteboard *)pasteboard provideDataForType:(NSString *)type
{
	NSData *tiffStream = nil;

	/*  Debug [NSAutoreleasePool enableDoubleReleaseCheck: YES];	*/
	/*  Debug [NSAutoreleasePool enableRelease:NO];	*/

	[AlertShower setSuppress: YES];

	if (filename) {
		NSFileManager *manager = [NSFileManager defaultManager];
		if ([manager isReadableFileAtPath:filename])
			tiffStream = [self openDataFromFile: filename];
	}

	if (tiffStream == nil) {
		tiffStream = [NSMutableData dataWithCapacity: 0];
		[tiffStream initWithContentsOfFile:
			[[self resource]
				stringByAppendingPathComponent: ErrorImage]];
		if (tiffStream == nil) {
			NSLog(@"Error during searching ErrorImage");
			[AlertShower setSuppress: NO];
			return;
		}
	}

	// NSLog(@"tiffStream = 0x%x", (unsigned)tiffStream);

    NS_DURING
//	[pasteboard declareTypes:[NSArray arrayWithObject:NSTIFFPboardType]
//		owner:nil];
	[pasteboard setData:tiffStream forType:NSTIFFPboardType];

    NS_HANDLER
	if ([[localException name]
		isEqualToString: NSPasteboardCommunicationException])
		NSLog(@"Error occurred while converting file %@:", filename);
	else {
		NSLog(@"Error: %@", [localException name]);
		[localException raise];	/* Re-raise the exception */
	}
    NS_ENDHANDLER

	// [tiffStream release]; 
	/*  Debug  [NSAutoreleasePool showPools];	*/
	[AlertShower setSuppress: NO];
}

@end
