#import <Foundation/NSObject.h>
#import <AppKit/NSResponder.h>

#define  toyviewerTAB	@"filters"
#define  toyviewerRC	@".toyviewerrc"

@class ToyWin, NSImage, NSPasteboard, NSData, NSMenuItem;

@interface TVController:NSObject
{
	id	printInfo;
	id	menuToFront;
	id	menuClear;
	id	preference;
	id	imageOpCtr;
	id	backgCtr;
	id	waitmsg;
	BOOL	hasBGW;
}

// - (void)applicationWillFinishLaunching:(NSNotification *)notification;
- (void)applicationDidFinishLaunching:(NSNotification *)notification;
- (void)applicationWillTerminate:(NSNotification *)aNotification;
- (NSString *)resource;
- (int)getFTypeID:(NSString *)aType;
- (id)drawFile: (NSString *)fn;
- (NSData *)openDataFromFile:(NSString *)fn;
- (void)openFile:(id)sender;
- (void)openPasteBoard:sender;
- (void)autoDisplay:sender;
- (int)application:sender openFile:(NSString *)filename;

/* To receive services, implement these methods (delegate) */
- validRequestorForSendType:(NSString *)sendType returnType:(NSString *)returnType;
- (BOOL)readSelectionFromPasteboard:(NSPasteboard *)pb;

@end

@interface TVController (WindowManager)

- (BOOL)hasWindow;
- (void)newWindow:(ToyWin *)win;
- checkWindow: (ToyWin *)win delete:(BOOL)delflag;
- (void)deleteAllWindow:sender;
- (void)showAllWindow:sender;
- keyWindow;
- (void)showNextWindow:sender;
- keyParentWindow:(int)op;
- (BOOL)isOpened:(NSString *)newfile;
- (BOOL)isOpenedID: (ToyWin *)win;
- (void)print:(id)sender;
- (void)saveAs:sender;

- (void)attraction:sender;	// Info.Panel attraction

/* NSMenuActionResponder Protocol */
- (BOOL)validateMenuItem:(NSMenuItem *)aMenuItem;

@end


@interface TVController (BackgroundManager)

- (id)initWallpaper;
- (void)readWallpaperSetting:sender;
- (void)cleanBackground:sender;
- (void)backgMenuEnabled:(BOOL)flag;
- (void)toggleFront:sender;
- (void)backWinFront:(BOOL)flag;
- (void)makeBackground:sender;

@end


@interface TVController (PBService)

- (void)convertToTIFF:(NSPasteboard *)pasteboard userData:(NSString *)userData error:(NSString **)errorMessage;
- (void)pasteboard:(NSPasteboard *)sender provideDataForType:(NSString *)type;
- (void)registerServiceTypes:(NSString **)typestrs withID:(short *)typeids num:(int)typenum;

@end


extern TVController *theController;
