#import  <stdio.h>
#import  <libc.h>
#import  <stdlib.h>
#import  <objc/objc.h>
#import  "../common.h"
#import  "../getpixel.h"
#import "../WaitMessageCtr.h"
#import  "DCTscaler.h"

static void resizeCopy(float factor, commonInfo *newinf,
		unsigned char *map[], unsigned char *newmap[])
{
	int i, x, y, px, nx, pnum, alp;
	int elm[MAXPLANE];
	unsigned char *pp[MAXPLANE];
	int rstab[MAXWidth];

	pnum = (newinf->numcolors == 1) ? 1 : 3;
	alp = (newinf->alpha) ? pnum : 0;
	if ((x = newinf->width) < newinf->height)
		x = newinf->height;
	for (i = 0; i < x; i++)
		rstab[i] = (float)i / factor;
	for (i = 0; i < 5; i++)
		pp[i] = newmap[i];
	[theWaitMsg messageDisplay:
		NSLocalizedString(@"Resizing...", Resizing)];
	for (y = 0; y < newinf->height; y++) {
		resetPixel(map, rstab[y]);
		for (px = -1, x = 0; x < newinf->width; x++) {
			for (nx = rstab[x]; px < nx; px++)
				getPixelA(elm);
			for (i = 0; i < pnum; i++)
				*pp[i]++ = elm[i];
			if (alp)
				*pp[alp]++ = elm[ALPHA];
		}
	}
	[theWaitMsg messageDisplay: nil];
}

commonInfo *makeResizedMap(float factor, commonInfo *cinf,
		unsigned char *map[], unsigned char *newmap[])
{
	commonInfo *newinf = NULL;
	unsigned char *planes[MAXPLANE];
	int pn;

	planes[0] = NULL;
	if ((newinf = (commonInfo *)malloc(sizeof(commonInfo))) == NULL)
		goto ErrEXIT;
	*newinf = *cinf;
	newinf->width = cinf->width * factor;
	newinf->height = cinf->height * factor;
	newinf->xbytes = byte_length(newinf->bits, newinf->width);
        if (newinf->cspace == CS_Black)
		newinf->cspace = CS_White;
	newinf->isplanar = YES;
	newinf->pixbits = 0;	/* don't care */
	if (newinf->width > MAXWidth)
		goto ErrEXIT;
	newinf->palette = NULL;
	if (cinf->palette) {
		newinf->palette = copyPalette(cinf->palette, cinf->palsteps);
		if (newinf->palette == NULL)
			goto ErrEXIT;
	}
	pn = (cinf->numcolors == 1) ? 1 : 3;
	if (cinf->alpha) ++pn;
	if (allocImage(planes, newinf->width, newinf->height, 8, pn))
		goto ErrEXIT;
	if (initGetPixel(cinf) != 0)
		goto ErrEXIT;
	resizeCopy(factor, newinf, map, planes);

	if (newinf->bits == 8) {
		int i;
		for (i = 0; i < pn; i++)
			newmap[i] = planes[i];
	}else {
		if (allocImage(newmap,
			newinf->width, newinf->height, newinf->bits, pn))
			goto ErrEXIT;
		packWorkingImage(newinf, pn, planes, newmap);
		free((void *)planes[0]);
	}
	return newinf;

ErrEXIT:
	if (newinf) {
		if (newinf->palette) free((void *)newinf->palette);
		free((void *)newinf);
	}
	if (planes[0]) free((void *)planes[0]);
	return NULL;
}


static int shrink(int asz, PIXmat apix)
{
	int	i, j, val;
	unsigned char *p;

	val = 0;
	for (i = 0; i < asz; i++) {
		p = apix[i];
		for (j = 0; j < asz; j++)
			val += p[j];
	}
	val /= (asz * asz);
	if (val > 255) return 255;
	return val;
}

commonInfo *makeDCTResizedMap(commonInfo *cinf, int bsz, int asz,
		unsigned char *map[], unsigned char *newmap[])
{
	commonInfo *newinf = NULL;
	unsigned char *planes[MAXPLANE], *bufa[MAXPLANE], *bufb[MAXPLANE];
	PIXmat	apix, bpix;
	int	wida, widb;
	int	pn, i, x, y, nx, ny, ptr;
	DCTscaler *dct = nil;

	planes[0] = NULL;
	bufa[0] = bufb[0] = NULL;
	if (asz % bsz == 0) {
		if (bsz > 1) asz /= bsz, bsz = 1;
		/* dct = nil */
	}else
		dct = [[DCTscaler alloc] init:bsz :asz];

	if ((newinf = (commonInfo *)malloc(sizeof(commonInfo))) == NULL)
		goto ErrEXIT;
	*newinf = *cinf;
	newinf->width = cinf->width * bsz / asz;
	newinf->height = cinf->height * bsz / asz;
	x = (cinf->width + asz - 1) / asz;
	wida = x * asz;
	widb = x * bsz;
	if (newinf->width > widb) newinf->width = widb;
	newinf->bits = 8;
	newinf->xbytes = byte_length(newinf->bits, newinf->width);
	newinf->palette = NULL;
	newinf->palsteps = 0;
	newinf->isplanar = YES;
	newinf->pixbits = 0;	/* don't care */
	newinf->alpha = NO;	/* remove Alpha */
	if (cinf->cspace == CS_Black)
		newinf->cspace = CS_White;
	if (newinf->width > MAXWidth)
		goto ErrEXIT;
	pn = (cinf->numcolors == 1) ? 1 : 3;

	if (allocImage(bufa, wida, asz, 8, pn)
	 || allocImage(bufb, widb, bsz, 8, pn))
		goto ErrEXIT;
	if (allocImage(planes, newinf->width, newinf->height, 8, pn))
		goto ErrEXIT;
	if (initGetPixel(cinf) != 0)
		goto ErrEXIT;

	resetPixel(map, 0);
	[theWaitMsg messageDisplay:
		NSLocalizedString(@"Resizing...", Resizing)];
	[theWaitMsg setProgress:(cinf->height - 1)];
	for (y = 0, ny = 0, ptr = 0; y < cinf->height; ) {
		int	z, idx;
		int	elm[MAXPLANE];
		[theWaitMsg progress: y];
		for (z = 0, idx = 0; z < asz; z++) {
			if (++y > cinf->height) {
				int	svx = idx - wida;
				for (x = 0; x < wida; x++, idx++, svx++) {
					for (i = 0; i < pn; i++)
						bufa[i][idx] = bufa[i][svx];
				}
				continue;
			}
			for (x = 0; x < cinf->width; x++, idx++) {
				getPixelA(elm);
				for (i = 0; i < pn; i++)
					bufa[i][idx] = elm[i];
			}
			for ( ; x < wida; x++, idx++) {
				for (i = 0; i < pn; i++)
					bufa[i][idx] = elm[i];
			}
		}
		for (i = 0; i < pn; i++) {
		    for (x = 0, nx = 0; x < cinf->width; x += asz, nx += bsz) {
			for (z = 0; z < asz; z++)
				apix[z] = &bufa[i][wida * z + x];
			for (z = 0; z < bsz; z++)
				bpix[z] = &bufb[i][widb * z + nx];
			if (dct)
				[dct DCTrescale:bpix from:apix];
			else
				bufb[i][nx] = shrink(asz, apix);
		    }
		}
		for (z = 0; z < bsz; z++) {
			if (++ny > newinf->height)
				break;
			for (i = 0; i < pn; i++)
				memcpy(&planes[i][ptr], &bufb[i][widb * z],
					newinf->width);
			ptr += newinf->width;
		}
	}
	[theWaitMsg resetProgress];
	[theWaitMsg messageDisplay: nil];

	for (i = 0; i < pn; i++)
		newmap[i] = planes[i];

	if (dct) [dct release];
	free((void *)bufa[0]);
	free((void *)bufb[0]);
	return newinf;

ErrEXIT:
	if (newinf) free((void *)newinf);
	if (dct) [dct release];
	if (planes[0]) free((void *)planes[0]);
	if (bufa[0]) free((void *)bufa[0]);
	if (bufb[0]) free((void *)bufb[0]);
	return NULL;
}
