#import  "PercentView.h"
#import  <AppKit/psopsOpenStep.h>
#import  <AppKit/NSImage.h>
#import  <AppKit/NSGraphics.h>
#import  <Foundation/NSLock.h>

@implementation PercentView

/* Local Method */
- (void)drawCache
{
	NSRect rect, brect;
	float w, h;

	rect = [self frame];
	rect.origin.x = rect.origin.y = 0.0;
	[cache lockFocus];
	PSsetgray(NSLightGray);
	NSRectFill(rect);
	brect = rect;
	brect.size.width = (brect.size.width - 1.0) * percent;
	rect.origin.x = 1.0;
	PSsetgray(NSDarkGray);
	NSRectFill(brect);
	w = rect.size.width;
	h = rect.size.height;
	PSsetlinewidth(1.0);
	PSsetgray(NSBlack);
	PSmoveto(0.0, 0.0);
	PSrlineto(0.0, h);
	PSrlineto(w, 0.0);
	PSstroke();
	PSsetgray(NSWhite);
	PSmoveto(w-1, h);
	PSrlineto(0.0, -(h-1));
	PSrlineto(-(w-1), 0.0);
	PSstroke();
	[cache unlockFocus]; 
}

/* Local Method */
- (void)clean
{
	NSRect rect;

	rect = [self frame];
	rect.origin.x = rect.origin.y = 0.0;
	[cache lockFocus];
	PSsetgray(NSLightGray);
	NSRectFill(rect);
	[cache unlockFocus]; 
	[self lockFocus];
	PSsetgray(NSLightGray);
	NSRectFill(rect);
	[self unlockFocus]; 
}

/* Overload */
- (id)initWithFrame:(NSRect)frameRect
{
	[super initWithFrame:frameRect];
	percent = 0.0;
	cache = [NSImage alloc];
        [cache initWithSize: frameRect.size];
	return self;
}

- (void)dealloc
{
	if (cache) [cache release];
	[super dealloc];
}

- (void)reset:(id)sender
{
	percent = 0.0;
	[self clean];
	[self display];
}

/* Overload */
- (void)drawRect:(NSRect)r
{
	[cache compositeToPoint:(r.origin)
		fromRect:r operation:NSCompositeCopy];
}

/* Local Method */
- (void)drawSelf
{
	NSRect rect;

	rect = [self frame];
	rect.origin.x = rect.origin.y = 0.0;
	[self drawCache];
	[self lockFocus];
	[self drawRect:rect];
	[self unlockFocus]; 
	// [self display];
}

- (void)setFloatValue:(float)value
{
	if ((percent = value) >= 0.0)
		[self drawSelf];
}

- (void)takeFloatValueFrom:(id)sender
{
	percent = [sender floatValue];
	[self drawSelf];
}

@end
