#import "NSStringAppended.h"
#import <Foundation/NSData.h>
#import <string.h>

@implementation NSString (Appended)

+ (id)stringWithCStringInEUC:(const char *)cstr
{
	return [self stringWithCString:cstr];
	/* We can use "NSJapaneseEUCStringEncoding" encoding, also */
}

+ (id)stringWithCStringInSJIS:(const char *)cstr
{
	NSData *data;
	id str;

	data = [NSData dataWithBytes:(const void *)cstr length:strlen(cstr)];
	str = [[self alloc] initWithData:data encoding:NSShiftJISStringEncoding];
	[str autorelease];
	return str;
}

+ (id)stringWithCStringInUTF8:(const char *)cstr
{
	NSData *data;
	id str;

	data = [NSData dataWithBytes:(const void *)cstr length:strlen(cstr)];
	str = [[self alloc] initWithData:data encoding: NSUTF8StringEncoding];
	[str autorelease];
	return str;
}

+ (id)stringWithCStringInFS:(const char *)cstr
{
#ifdef __APPLE__
	return [self stringWithCStringInUTF8:cstr];
#else
	return [self stringWithCString:cstr];
#endif
}

- (const char *)cStringInEUC
{
	return [self cString];
	/* Only if default coding of cString is EUC. */
}

- (const char *)cStringInSJIS
{
	NSData *data = [self dataUsingEncoding:NSShiftJISStringEncoding
			allowLossyConversion:NO];
	return [data bytes];
}

- (const char *)cStringInUTF8
{
	NSData *data = [self dataUsingEncoding: NSUTF8StringEncoding
			allowLossyConversion:NO];
	return [data bytes];
}

- (const char *)cStringInFS
{
#ifdef __APPLE__
	return [self cStringInUTF8];
#else
	return [self cString];
#endif
}

- (NSString *)newStringByAppendingPathComponent:(NSString *)obj
{
	NSString *tmp;

	if ([obj length] < 3 || [obj characterAtIndex:1] != ':')
		return [self stringByAppendingPathComponent: obj];

	/* obj may have form like MS-DOS filename, that is, "C:xxxxx".	*/
	/* Usual method stringByAppendingPathComponent: can't append	*/
	/* such component well. */

	tmp = [self stringByAppendingPathComponent:[obj substringToIndex:1]];
	return [tmp stringByAppendingString:[obj substringFromIndex:1]];
}

@end
