#import  "TonePanelCtrl.h"
#import  <AppKit/NSControl.h>
#import  <AppKit/NSMatrix.h>
#import  <stdio.h>
#import  "../common.h"
#import  "../ImageOpCtr.h"
#import  "../ImageOpr.h"
#import  "ColorTuner.h"


@implementation TonePanelCtrl

/* Local Method */
- (id)setFormatFloat:(float)value to:target
{
	NSString *str;

	str = [NSString stringWithFormat:@"%4.2f", (int)(value * 20.0) / 20.0];
	[target setStringValue:str];
	return target;
}

- (void)reset:sender
{
	int	i;

	if ([sender selectedTag] == 0) {
		[mainSlider setFloatValue:1.0];
		[self setFormatFloat:1.0 to:mainIndicator];
		return;
	}
	for (i = 0; i < N_Colors; i++) {
		[[colorSliders cellAtRow:i column:0] setFloatValue:1.0];
		[self setFormatFloat:1.0
			to:[colorIndicators cellAtRow:i column:0]];
	} 
}

- (void)changeMainValue:sender
{
	[self setFormatFloat:[mainSlider floatValue] to:mainIndicator];
}

- (void)changeColorValue:sender
{
	id	cell;
	int	tag;
	float	v;

	cell = [sender selectedCell];
	tag = [cell tag];
	v = [cell floatValue];
	[self setFormatFloat:v to:[colorIndicators cellAtRow:tag column:0]]; 
}

- (void)colorTone:sender
{
	int	i;
	float	values[N_Colors];
	id	she;

	for (i = 0; i < N_Colors; i++)
		values[i]
		= [[colorIndicators cellAtRow:i column:0] floatValue] - 1.0;
	she = [[ColorTuner alloc] init];
	if (she == nil)
		return;
	[she setSaturation:[mainSlider floatValue] andHue:values];
	[she createNewImage];
	[she release];
}

@end
