
#import  "SoftFrameCtr.h"
#import  <AppKit/NSColorWell.h>
#import  <AppKit/NSColor.h>
#import  "../ImageOpCtr.h"
#import  "../ImageOpr.h"
#import  "../common.h"
#import  "SoftFramer.h"

@implementation SoftFrameCtr

- (void)changeAlpha:(id)sender
{
	[colorwell setEnabled:![alphaSW state]]; 
}

- (void)selectShape:(id)sender
{
	int tag = [shape selectedTag];
	if (tag == S_BezelConvex || tag == S_BezelConcave) {
		[alphaSW setState:NO];
		[self changeAlpha:self];
		[alphaSW setEnabled:NO];
	}else
		[alphaSW setEnabled:YES];
}

- (void)doit:sender
{
	int	i;
	float	cl[3];
	int	color[MAXPLANE];
	id	she;
	BOOL	alpf = [alphaSW state];

	if (alpf) {
		for (i = 0; i < 3; i++)
			color[i] = 255;
		color[ALPHA] = AlphaTransp;
	}else {
		[[[colorwell color]
			colorUsingColorSpaceName:NSCalibratedRGBColorSpace]
			getRed:&cl[0] green:&cl[1] blue:&cl[2] alpha:NULL];
		for (i = 0; i < 3; i++)
			color[i] = cl[i] * 255;
		color[ALPHA] = AlphaOpaque;
	}

	she = [[SoftFramer alloc] init];
	if (she == nil)
		return;
	[she setFrame:[shape selectedTag] ratio:[widthSL intValue]/100.0
		bgColor:color withAlpha:alpf];
	[she createNewImage];
	[she release];
}


@end
