#import "Embosser.h"
#import <Foundation/NSObject.h>
#import <Foundation/NSBundle.h>	/* LocalizedString */
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <math.h>
#import "../WaitMessageCtr.h"
#import "../common.h"
#import "../getpixel.h"

@implementation Embosser

+ (int)opcode
{
	return Emboss;
}

+ (t_weight)weightTabel
{
	static const char embossTab[5][5] = {
		{0,  0,  0,  0,  0},
		{0, -2, -1,  0,  0},
		{0, -1,  0,  1,  0},
		{0,  0,  1,  2,  0},
		{0,  0,  0,  0,  0}
	};
	return embossTab;
}

static void emboss_sub(int *pix, int *totalw, int *totalv, int cnum, float factor, float bright)
{
	int	n, w;
	if (cnum == 1) {
		pix[0] = totalv[0] * factor + 128 + (pix[0] - 128) * bright;
		return;
	}
	w = (int)(factor * Bright255(totalv[0], totalv[1], totalv[2]));
	for (n = 0; n < cnum; n++)
		pix[n] = w + 128 + (pix[n] - 128) * bright;
}

+ (f_enhance)enhanceFunc
{
	return emboss_sub;
}

- (id)waitingMessage
{
	return [theWaitMsg messageDisplay:
		NSLocalizedString(@"Embossing...", Embossing)];
}

- (void)setFactor:(float)fval andBright:(float)bval
{
	factor = fval;
	bright = bval;
}

- (BOOL)makeNewPlane:(unsigned char **)newmap with:(commonInfo *)newinf
{
	if (![super makeNewPlane:newmap with:newinf])
		return NO;
	if (bright < 0.005 && newinf->numcolors > 1) {
		size_t	w = newinf->width * newinf->height;
		newinf->numcolors = 1;	/* Mono */
		newinf->cspace = CS_White;
		newmap[0] = (unsigned char *)realloc(newmap[0], w);
		newmap[1] = NULL;
	}
	return YES;
}

@end
