#import "Contourer.h"
#import <Foundation/NSObject.h>
#import <Foundation/NSBundle.h>	/* LocalizedString */
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <math.h>
#import "../WaitMessageCtr.h"
#import "../common.h"
#import "../getpixel.h"
#import "colorLuv.h"

struct contr {
	unsigned char	dirc;
	unsigned char	voided;
	short	val;
};
enum {
	dL = 0,
	dUL,	/* Upper Left */
	dUp,
	dUR,
	dR,
	dDR,
	dDw,
	dDL,
	dABSO = 8,
	dNONE
};


@implementation Contourer

+ (int)opcode
{
	return Contour;
}

- (id)waitingMessage
{
	return [theWaitMsg messageDisplay:
		NSLocalizedString(@"Contouring...", Contouring)];
}

- (void)setFactor:(float)dval andBright: (float)bval
{
	factor = dval;
	bright = bval;
}

static void thinline(struct contr *shp, int width, int height)
{
	static const unsigned char didx[8][2] = {
		{ 1, 2 }, { 2, 2 }, { 2, 1 }, { 2, 0 },
		{ 1, 0 }, { 0, 0 }, { 0, 1 }, { 0, 2 }
	};
	int	x, y, i;
	int	p[3];

	[theWaitMsg messageDisplay:
		NSLocalizedString(@"Thinning Lines...", ThinningLines)];
	// [theWaitMsg setProgress:(height - 1)];
	for (y = 2; y < height; y++) {
		// [theWaitMsg progress: y];
		p[2] = width * y;
		p[1] = p[2] - width;
		p[0] = p[1] - width;
		for (x = 2; x < width; x++) {
			int	d, e, ep;
			d = shp[p[1]+1].dirc;
			if (shp[p[1]+1].val == 0 || d == dABSO)
				goto Next;
			e = shp[ ep = p[didx[d][0]] + didx[d][1] ].dirc;
			if ((e & 3) == (d & 3)
					&& shp[p[1]+1].val < shp[ep].val)
				shp[p[1]+1].voided = 1;
Next:			p[0]++;
			p[1]++;
			p[2]++;
		}
	}

	/* remove isolated pixel */
	for (y = 2; y < height; y++) {
		// [theWaitMsg progress: y];
		p[2] = width * y;
		p[1] = p[2] - width;
		p[0] = p[1] - width;
		for (x = 2; x < width; x++) {
			if (shp[p[1]+1].voided)
				goto NextIso;
			for (i = 0; i < 8; i++) {
				if (!shp[ p[didx[i][0]] + didx[i][1] ].voided)
					goto NextIso;
			}
			shp[p[1]+1].voided = 1;

NextIso:		p[0]++;
			p[1]++;
			p[2]++;
		}
	}
	// [theWaitMsg resetProgress];
}

#if 0
#define  TW		3
#define  TSZ		(TW*2 + 1)
#define  Clusts		8

static const char dirTabs[TSZ][TSZ] = {
	{ 5, 6, 6, 6, 7, 7, 7},
	{ 5, 5, 6, 6, 7, 7, 0},
	{ 5, 5, 5, 6, 7, 0, 0},
	{ 4, 4, 4, 8, 0, 0, 0},
	{ 4, 4, 3, 2, 1, 1, 1},
	{ 4, 3, 3, 2, 2, 1, 1},
	{ 3, 3, 3, 2, 2, 2, 1},
};
#else
#define  TW		2
#define  TSZ		(TW*2 + 1)
#define  Clusts		8

static const char dirTabs[TSZ][TSZ] = {
	{ 5, 6, 6, 7, 7},
	{ 5, 5, 6, 7, 0},
	{ 4, 4, 8, 0, 0},
	{ 4, 3, 2, 1, 1},
	{ 3, 3, 2, 2, 1},
};
#endif

static void contour_calc(commonInfo *cinf,
	struct contr *sheet, t_Luv **planes, int lim)
{
	int i, j, x, y, ptr;
	int cnum, alp;

	cnum = cinf->numcolors;
	if (cinf->alpha) alp = cnum;
	else alp = 0;

	[theWaitMsg setProgress:(cinf->height - 1)];
	for (y = 0; y < cinf->height; y++) {
	    int xlow, xhigh, ylow, yhigh;
	    int n, w, pw, d;
	    int pxw[4], pxc;
	    int clst[Clusts+1][4], clstnum[Clusts+1];
	    double clstval[Clusts+1], mx;

	    [theWaitMsg progress: y];
	    ylow = (y > TW) ? -TW : -y;
	    if ((yhigh = cinf->height - 1 - y) > TW) yhigh = TW;
	    ptr = cinf->width * y;
	    for (x = 0; x < cinf->width; x++, ptr++) {
		if (alp && isLuvTrans(planes[0][ptr])) {
			sheet[ptr].voided = 1;
			continue;
		}
		xlow = (x > TW) ? -TW : -x;
		if ((xhigh = cinf->width - 1 - x) > TW)
			xhigh = TW;
		for (n = 0; n < cnum; n++)
		    pxw[n] = 0;
		for (i = 0; i < Clusts+1; i++) {
		    clstnum[i] = 0;
		    for (n = 0; n < cnum; n++)
			clst[i][n] = 0;
		}
		pxc = 0;
		for (i = ylow; i < yhigh; i++) {
		    pw = cinf->width * (y + i) + x;
		    for (j = xlow; j < xhigh; j++) {
			pxc++;
			w = dirTabs[i+TW][j+TW];
			clstnum[w]++;
			for (n = 0; n < cnum; n++) {
			    int cc = planes[n][pw+j];
			    pxw[n] += cc;
			    clst[w][n] += cc;
			}
		    }
		}
		if (pxc <= 4)	/* too few pixels */
		    continue;
		for (i = 0; i < Clusts+1; i++) {
		    double cl[n], av[n];
		    clstval[i] = 0.0;
		    if (i >= Clusts) { /* center pixel */
			for (n = 0; n < cnum; n++) {
			    cl[n] = clst[Clusts][n];
			    av[n] = (pxw[n] - cl[n]) / (pxc - 1);
			}
		    }else {
			int k = (i + 7) & 7;
			j = (i + 1) & 7;
			w = clstnum[i] + clstnum[j] + clstnum[k];
			if (w <= 0 || w >= pxc)
			    continue;
			for (n = 0; n < cnum; n++) {
			    double b = clst[i][n] + clst[j][n] + clst[k][n];
			    cl[n] = b / w;
			    av[n] = (pxw[n] - b) / (pxc - w);
			}
		    }

		    if (cnum == 1)
			clstval[i] = cl[0] - av[0];
		    else {
			double v, sgn;
			sgn = (cl[0] >= av[0]) ? 1.0 : -1.0;
			v = 0.0;
			for (n = 0; n < cnum; n++) {
			    double t = (cl[n] - av[n]);
			    v += t * t;
			}
			clstval[i] = sqrt(v) * sgn;
		    }
		}

		d = dABSO;
		mx = 0;	// clstval[Clusts];
		for (i = 0; i < Clusts; i++)
		    if (clstval[i] > mx) {
			if (clstval[Clusts] < clstval[i] / 2)
			    mx = clstval[d = i];
		    }
		sheet[ptr].val = mx;
		sheet[ptr].dirc = d;
		if ((int)mx < lim)
			sheet[ptr].voided = 1;
	    /* NEXT-X */
	    }
	}
	[theWaitMsg resetProgress];
}

- (BOOL)makeNewPlane:(unsigned char **)newmap with:(commonInfo *)newinf
{
	int i, x, y, ptr;
	int cnum, pnum, only = 0;
	int lim, hlim;
	t_Luv *luvp[3];
	int alp, sz;
	struct contr *sheet = NULL;

	cnum = pnum = cinf->numcolors;
	if (bright < 0.02)
		only = 1;
	if (cinf->alpha) alp = pnum++;
	else alp = 0;

	luvp[0] = NULL;
	sz = cinf->width * cinf->height;
	sheet = (struct contr *)malloc(sizeof(struct contr) * sz);
	if (sheet == NULL)
		goto ErrEXIT;
	if (allocLuvPlanes(luvp, sz, ((cinf->numcolors > 1) ? 3 : 1)) != 0)
		goto ErrEXIT;
	if (allocImage(newmap, cinf->width, cinf->height, 8,
			(only ? 1 : pnum)) != 0)
		goto ErrEXIT;

	lim = ((cnum == 1) ? LuvMonoWidth : LuvColorWidth)
		/ pow(2, factor + 3.0);		/* factor > -3.0 : should be */
	hlim = lim * 4;

	/* Copy the image into luvp[] and newmap[], and clean sheet[] */
	initLuv();
	resetPixel(map, 0);
	for (y = 0; y < cinf->height; y++) {
		ptr = cinf->width * y;
		for (x = 0; x < cinf->width; x++) {
			int elm[MAXPLANE];
			t_Luv elv[3];
			(void)getPixelA(elm);
			transRGBtoLuv(elv, elm, cnum, alp);
			for (i = 0; i < cnum; i++) {
				luvp[i][ptr] = elv[i];
			}
			if (!only) {
				for (i = 0; i < cnum; i++)
					newmap[i][ptr] = elm[i];
				if (alp)
					newmap[alp][ptr] = elm[alp];
			}
			sheet[ptr].dirc = dNONE;	/* Not Contour */
			sheet[ptr].val = 0;
			sheet[ptr++].voided = 0;
		}
	}

	if (newinf->alpha && !hadAlpha()) {
		newinf->alpha = NO;
		alp = 0;
	}
	/* make contour */
	contour_calc(cinf, sheet, luvp, lim);
	thinline(sheet, cinf->width, cinf->height);

	if (only) {
		newinf->cspace = CS_White;
			/* getPixel() fixes 0 as Black */
		newinf->numcolors = 1;
		newinf->alpha = NO;
		for (y = 0; y < cinf->height; y++) {
		    ptr = cinf->width * y;
		    for (x = 0; x < cinf->width; x++) {
			if (sheet[ptr].voided)
				newmap[0][ptr] = 255;
			else {
				int v;
				if ((v = hlim - sheet[ptr].val) < 0) v = 0;
				else
					v = v * 127 / (hlim - lim);
				newmap[0][ptr] = v;
			}
			ptr++;
		    }
		}
	}else {
		for (y = 0; y < cinf->height; y++) {
		    ptr = cinf->width * y;
		    for (x = 0; x < cinf->width; x++) {
			float	t;
			if (sheet[ptr].voided) {
			    for (i = 0; i < cnum; i++) {
				t = (255.0 - newmap[i][ptr]) * bright;
				newmap[i][ptr] = 255 - (int)t;
			    }
			}else {
			    int v;
			    double t;
			    if ((v = hlim - sheet[ptr].val) < 0) {
				for (i = 0; i < cnum; i++)
				    newmap[i][ptr] = 0;
			    }else {
				t = (double)v / (hlim * 2);
				for (i = 0; i < cnum; i++)
				    newmap[i][ptr] *= t;
			    }
			}
			ptr++;
		    }
		}
	}

	free((void *)sheet);
	free((void *)luvp[0]);
	return YES;
ErrEXIT:
	if (sheet) free((void *)sheet);
	if (luvp[0]) free((void *)luvp[0]);
	return NO;
}

@end
