#import "ColorChanger.h"
#import <AppKit/NSApplication.h>
#import <AppKit/NSGraphics.h>	/* PS_funcs */
#import <AppKit/psopsNeXT.h>	/* PS_funcs */
#import <AppKit/NSImage.h>
#import <AppKit/NSBitmapImageRep.h>
#import <AppKit/NSControl.h>
#import <AppKit/NSPanel.h>
#import <AppKit/NSTextField.h>
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <libc.h>
#import "../TVController.h"
#import "../ToyWin.h"
#import "../ToyWinEPS.h"
#import "../ToyView.h"
#import "../ImageOpr.h"
#import "../AlertShower.h"
#import "../getpixel.h"

#define  MONO_THRESHOLD	128


@implementation ColorChanger

+ (int)opcode
{
	return ColorChange;
}

- (void)setColor:(const int *)ocl to:(const int *)ncl with:(float)comp uniform:(BOOL)flag
{
	int	i;

	for (i = 0; i < MAXPLANE; i++) {
		origclr[i] = ocl[i];
		newclr[i] = ncl[i];
	}
	comparison = comp;
	uniform = flag;
}

- (void)setupWith:(ToyView *)tv
{
	int d;

	[super setupWith: tv];
	initLuv();
	transRGBtoLuv(origluv, origclr, cinf->numcolors, 0);
	d = MONO_THRESHOLD * comparison;
	cdiffwid = d * d;
	isMono = (cinf->numcolors < 3);
	bthreshm = origluv[0] - d;
	bthreshp = origluv[0] + d;
}

/* Local Method */
- (BOOL)isNearColor:(const int *)elm
{
	int i, v, w;
	t_Luv luv[3];

	if (isMono) {
		transRGBtoLuv(luv, elm, 1, 0);
		return (luv[0] < bthreshp && luv[0] > bthreshm);
	}
	transRGBtoLuv(luv, elm, 3, 0);
	w = origluv[0] - luv[0];
	v = w * w;
	for (i = 1; i < 3; i++) {
		w = origluv[i] - luv[i];
		v += w * w * 2;
	}
	return (v <= cdiffwid);
}

- (commonInfo *)makeNewInfo
{ /* Note that this method is called in method "doOperation", that is,
     after method "setupWith:" is called.  Therefore, variable "selected"
     is set already. */

	commonInfo *newinf = [super makeNewInfo];
	if (newinf == NULL)
		return NULL;
        if (cinf->alpha && origclr[ALPHA] == AlphaTransp && !selected)
		newinf->alpha = NO;
	if (newclr[ALPHA] == AlphaTransp)
		newinf->alpha = YES;
	if (cinf->numcolors == 1) {
		if (newclr[RED] != newclr[GREEN]
				|| newclr[RED] != newclr[BLUE]) {
			newinf->numcolors = 3;
			newinf->cspace = CS_RGB;
		}else {
			newinf->numcolors = 1;
			newinf->cspace = CS_White;
		}
	}
	return newinf;
}

- (BOOL)makeNewPlane:(unsigned char **)newmap with:(commonInfo *)newinf
{
	int pn, alp, cn;
	int x, y, i;

	newmap[0] = NULL;
	pn = cn = (newinf->numcolors == 1) ? 1 : 3;
	if (newinf->alpha) alp = pn++;
	else alp = 0;
	if (allocImage(newmap, newinf->width, newinf->height, 8, pn))
		return NO;	/* return immediately */
	resetPixel(map, 0);
	for (y = 0; y < newinf->height; y++) {
	    int elm[MAXPLANE], gen[MAXPLANE];
            BOOL ysel, xsel;
	    const int *cp;
	    int ptr = newinf->width * y;
            ysel = (selected && yorg <= y && y <= yend);
	    for (x = 0; x < newinf->width; x++, ptr++) {
		getPixel(&elm[RED], &elm[GREEN], &elm[BLUE], &elm[ALPHA]);
		xsel = (ysel && xorg <= x && x <= xend);
                if (!selected || (outside && !xsel) || (!outside && xsel)) {
		    if (origclr[ALPHA] == AlphaTransp)
			cp = (elm[ALPHA] == AlphaTransp) ? newclr : elm;
		    else if (elm[ALPHA] == AlphaTransp)
			cp = elm;	/* origclr[ALPHA] != AlphaTransp */
		    else if (comparison == 0.0) {
			for (i = 0; i < cn; i++)
				if (origclr[i] != elm[i]) break;
			cp = (i >= cn) ? newclr : elm;
		    }else if ([self isNearColor:elm]) {
			if (uniform) cp = newclr;
			else {
			    int d;
			    for (i = 0; i < cn; i++) {
				d = elm[i] - origclr[i] + newclr[i];
				gen[i] = (d>255)? 255: ((d<0)? 0: d);
			    }
			    if (alp) gen[ALPHA] = newclr[ALPHA];
			    cp = gen;
			}
		    }else
		    	cp = elm;
		}else
		    cp = elm;
		for (i = 0; i < cn; i++)
		    newmap[i][ptr] = cp[i];
		if (alp)
		    newmap[alp][ptr] = cp[ALPHA];
	    }
	}
	return YES;
}

@end
