#import <Foundation/NSObject.h>

@class NSMenuItem;

@interface ImageOpCtr:NSObject
{
	id	imageOpr;
	id	monoPanel;
	id	rotatePanel;
	id	angleText;
	id	enhancePanel;
	id	clrChangePanel;
	id	randomPanel;
	id	toolPanel;
	id	toolView;
	id	toolButton;
	id	sframePanel;
	id	clrTonePanel;
	id	posterizePanel;
	id	resizePanel;
	id	reducePanel;
	id	posterDiffSlider;
	id	posterCtrlSlider;
	id	commentPanel;
	id	commentText;
	id	commentMsg;
}

/* NSMenuActionResponder Protocol */
- (BOOL)validateMenuItem:(NSMenuItem *)aMenuItem;

- (void)loadNewTool:sender;
- (void)forwardInvocation:(NSInvocation *)anInvocation;
- (id)imageOperator;
- (void)saveData;

- (void)activateToolPanel:sender;
- (void)rotateByAngle:sender;
- (void)posterize:sender;
- (void)doResize:sender by:(int)op;
- (void)convertCMYKtoRGB:sender;

- (void)flip:sender;
- (void)readyForResize:sender;
- (void)newBitmap:sender;
- (void)reduce:sender;

@end


@interface ImageOpCtr (EditComm)

- (void)editComment:sender;
- (void)writeComment:sender;
- (void)SJIStoJIS:sender;

@end
