/*
	Background.m
		based on "Background"
		by Scott Hess and Andreas Windemut (1991)
	ver.2.0
		1997-12-31  by T. Ogihara
	ver.3.1
		1999-04-10  by T. Ogihara
*/

#import "Background.h"
#import <AppKit/psopsOpenStep.h>
#import <AppKit/NSApplication.h>
#import <AppKit/NSImage.h>
#import <AppKit/NSControl.h>
#import <AppKit/NSScreen.h>
#import <AppKit/NSColor.h>
#import <Foundation/NSData.h>
#import "FullScreenWindow.h"
#import "../PSsplat.h"
#import "../backgops.h"
#import "../TVController.h"
#import "../PrefControl.h"

#define  Bright(r, g, b)	(((r)*30 + (g)*59 + (b)*11 + 50) / 100)
#define  PSsplat(r, p)   _PSsplat( (r)->origin.x, (r)->origin.y, \
		(r)->size.width, (r)->size.height, (p)->x, (p)->y )
#define  TooLargeRatio	2.2

enum { backgMONO, backgCOLOR };	/* bgDepth */

/* class variable */
NSRect screenRect;

static int	bgDepth;


@implementation Background

+ (void)initialize
{
	NSScreen *sc = [NSScreen mainScreen];
        NSWindowDepth depth;

	screenRect.size = [sc frame].size;
	screenRect.origin.x = screenRect.origin.y = 0;
	depth = [sc depth];
	bgDepth = (NSNumberOfColorComponents(NSColorSpaceFromDepth(depth)) <= 2)
			? backgMONO : backgCOLOR;
}

- (id)init
{
	[super initWithFrame:screenRect];
	image = NULL;
	isfront = NO;
	return self;
}

- (void)dealloc
{
	if (image != nil)
		[image release];
	[super dealloc];
}

/* Local Method */
- getDafaultBGColor
{
	[thePreference backgroungColor:bgColor front:isfront];
	if (bgDepth == backgMONO)
		bgColor[0] = Bright(bgColor[0], bgColor[1], bgColor[2]);
	return self;
}

/* Local Method */
- paintDefault:(NSRect *)rect
{
	if (bgDepth == backgMONO)
		PSsetgray(bgColor[0]);
	else
		PSsetrgbcolor(bgColor[0], bgColor[1], bgColor[2]);
	NSRectFill(*rect);
	return self;
}

/* Local Method */
- (NSWindow *)initFrameWindow:(int)mask
{
	NSPoint p;
	NSWindow *win = [FullScreenWindow allocWithZone:[self zone]];
        [win initWithContentRect:screenRect styleMask:mask
		backing:NSBackingStoreBuffered defer:NO];
	[win setContentView:self];
	[win useOptimizedDrawing:YES];
	[win setAcceptsMouseMovedEvents:NO];
	if (mask) {
#ifdef MacOSX
		p.x = -7.0;
		p.y = -8.0;
#else
		p.x = -1.0;
		p.y = -2.0;
	/* 2.0 = width of border line + Title "Line" for emergency */
#endif
	}else
		p.x = p.y = 0.0;
	[win setFrameOrigin:p];
	[self getDafaultBGColor];
/* { */	[self lockFocus];
	[self paintDefault: &screenRect];
/* } */	[self unlockFocus];
	return win;
}

- (NSWindow *)initWinAttr
{
	NSWindow *win = [self initFrameWindow: 0];
	[self toBehind:self];
	return win;
}

- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent
{
	return isfront;
}

- (void)toBehind:sender
{
	[[self window] setLevel: WLevel_Behind];
	[[self window] orderWindow:NSWindowBelow relativeTo:0];
	[theController backWinFront:(isfront = NO)]; 
}

- (void)toFront:sender
{
	[[self window] setLevel: WLevel_Front];
	[[self window] orderWindow:NSWindowAbove relativeTo:0];
	[theController backWinFront:(isfront = YES)]; 
}

- (void)mouseDown:(NSEvent *)event
{
	NSEventType	typ;

	typ = [event type];
	if (isfront) {
		[self toBehind:self];
		return;
	}
	if (typ == NSLeftMouseDown && ([event modifierFlags] & NSShiftKeyMask))
		[self toFront:self];
}

- (BOOL)isFront
{
	return isfront;
}


/* Local Method */
- (double)enlargeScale: (const NSSize *)size by: (int)method err:(int *)err
{
	double xr, yr, w, ratio = 1.0;

	if (err) *err = 0;
	xr = (double)screenRect.size.width / size->width;
	yr = (double)screenRect.size.height / size->height;
	if (method == bk_FitScreen)
		ratio = (xr < yr) ? xr : yr;
	else if (err == NULL)	/* bk_CoverScreen for Bitmap */
		ratio = (xr > yr) ? xr : yr;
	else { /* bk_CoverScreen */
		if (xr > yr) {
			w = xr * size->height / (double)screenRect.size.height;
			ratio = xr;
		}else {
			w = yr * size->width / (double)screenRect.size.width;
			ratio = yr;
		}
		if (w > TooLargeRatio) { /* Too Large */
			ratio = (xr < yr) ? xr : yr; /* bk_FitScreen */
			*err = 1;
		}
	}
	return ratio;
}

- setImage: (NSImage *)backimage hasAlpha:(BOOL)alpha with: (int)method
{
	NSSize sz, nwsz;
	NSPoint pnt;
	double	ratio = 1.0;
	int	mode;
	BOOL	large = NO;

	drawMethod = method;
	sz = [backimage size];
	if (sz.width <= 0 || sz.height <= 0)
		return self;
	if (image != NULL)
		[image release];
	image = [NSImage allocWithZone:[self zone]];
	[image setScalesWhenResized:YES];
	if (image == NULL)
		return nil;

	if (drawMethod == bk_FitScreen || drawMethod == bk_CoverScreen) {
		ratio = [self enlargeScale:&sz by:drawMethod err:NULL];
		nwsz.width = sz.width * ratio;
		nwsz.height = sz.height * ratio;
		drawMethod = bk_Centering;
	}else
		nwsz = sz;
	/* To make size of 'image' smaller than screen */
	pnt.x = pnt.y = 0;
	if (nwsz.width > screenRect.size.width) {
		pnt.x = (screenRect.size.width - nwsz.width) / (ratio * 2.0);
		nwsz.width = screenRect.size.width;
		large = YES;
	}
	if (nwsz.height > screenRect.size.height) {
		pnt.y = (screenRect.size.height - nwsz.height) / (ratio * 2.0);
		nwsz.height = screenRect.size.height;
		large = YES;
	}

	if (large) {
		sz.width = nwsz.width / ratio;
		sz.height = nwsz.height / ratio;
	}
	[image setSize:sz];
	[self getDafaultBGColor];
	mode = alpha ? NSCompositeSourceOver : NSCompositeCopy;
/* { */	[image lockFocus];
	if (alpha) {
		NSRect rect;
		rect.size = sz;
		rect.origin.x = rect.origin.y = 0;
		[self paintDefault: &rect];
	}
	[backimage compositeToPoint:pnt operation:mode];
/* } */	[image unlockFocus];
	[image setSize:nwsz];

	return self;
}

- setStream: (NSData *)data with: (int)method
{
	NSImage *backimage;
	NSSize	sz, nwsz;
	int	err = 0;
	id	rtn;

	if ((backimage = [NSImage allocWithZone:[self zone]]) == NULL)
		return nil;
	[backimage initWithData: data];
	sz = [backimage size];
	if (method == bk_FitScreen || method == bk_CoverScreen) {
		double r = [self enlargeScale:&sz by:method err:&err];
		nwsz.width = (int)(sz.width * r + 0.5);
		nwsz.height = (int)(sz.height * r + 0.5);
		method = bk_Centering;
		[backimage setScalesWhenResized:YES];
		[backimage setSize:nwsz];
	}
	rtn = [self setImage: backimage hasAlpha:YES with:method];
	[backimage release];
	return (err ? nil : rtn);
}

- (void)drawRect:(NSRect)rect
{
	NSSize sz;
	NSPoint pnt;

	if (image == nil)
		return;
	sz = [image size];
	if (sz.width <= 0 || sz.height <= 0)
		return;

	if (drawMethod == bk_Centering) { /* Centering */
		[self paintDefault: &rect];
		pnt.x = (screenRect.size.width - sz.width) / 2;
		pnt.y = (screenRect.size.height - sz.height) / 2;
		[image compositeToPoint:pnt operation:NSCompositeCopy];
	}else {
		int i, wd, ht;
		NSRect irect;

		if (drawMethod == bk_Tiling || sz.height >= screenRect.size.height) {
	/* Tiling */
			wd = irect.size.width = sz.width;
			ht = irect.size.height = sz.height;
		}else {
	/* Brick Work */
			wd = (int)(sz.width) / 2;
			pnt.x = -wd, pnt.y = sz.height;
			[image compositeToPoint:pnt operation:NSCompositeCopy];
			pnt.x = sz.width - wd;
			[image compositeToPoint:pnt operation:NSCompositeCopy];
			wd = irect.size.width = sz.width;
			ht = irect.size.height = sz.height * 2;
		}
		pnt.x = pnt.y = 0;
		[image compositeToPoint:pnt operation:NSCompositeCopy];

		irect.origin = pnt;
		for(i = wd; i < screenRect.size.width; i += wd) {
			pnt.x = i;
			PSsplat(&irect, &pnt);
		}
		pnt.x=0;
		irect.size.width = screenRect.size.width;
		for(i = ht; i < screenRect.size.height; i += ht) {
			pnt.y = i;
			PSsplat(&irect, &pnt);
		}
	}
}

@end
