/*
	Background.h
		based on "Background"
		by Scott Hess and Andreas Windemut (1991)
*/

#import <AppKit/NSView.h>
#import <AppKit/dpsclient.h>
#import <AppKit/NSDPSContext.h>
#import <AppKit/NSWindow.h>

#define  WLevel_Behind	(NSNormalWindowLevel-2)
#define  WLevel_Front	(NSMainMenuWindowLevel+5)

/* class variable */
extern NSRect screenRect;


@class NSImage, NSData;

@interface Background:NSView
{
	NSImage *image;
	int	drawMethod;
	BOOL	isfront;
	float	bgColor[3];
}

+ (void)initialize;

- (id)init;
- (void)dealloc;
- (NSWindow *)initWinAttr;
- (void)toBehind:sender;
- (void)toFront:sender;
- (BOOL)isFront;
- (void)mouseDown:(NSEvent *)event;
- (BOOL)acceptsFirstMouse:(NSEvent *)theEvent;
- setImage: (NSImage *)backimage hasAlpha:(BOOL)alpha with: (int)method;
- setStream: (NSData *)data with: (int)method;
- (void)drawRect:(NSRect)r;

/* Local Method */
- (NSWindow *)initFrameWindow:(int)mask;

@end
