@echo off
rem **********************************************************************
rem ** YBOS.bat
rem ** Copyright (C)1998 by Eric Sunshine <sunshine@sunshineco.com>
rem ** Version 2.0
rem **
rem ** A Windows NT batch file for toggling between Apple YellowBox and
rem ** NeXT OpenStep environments.
rem **
rem ** REVISION HISTORY
rem ** 23 Oct 1998 Eric Sunshine - Version 2.0; reworked for YB DR2.
rem ** 14 May 1998 Eric Sunshine - Added "restore" functionality.
rem ** 10 May 1998 Eric Sunshine - Version 1.0; created.
rem **********************************************************************

setlocal
echo.

rem **********************************************************************
rem ** Configuration parameters
rem **   SourceDrive - drive on which YellowBox and OpenStep are installed
rem **   TargetDrive - virtual drive to which PATH and Registry refer
rem **   DemoDrive   - virtual drive pointing at "Demos" directory
rem **   DevDrive    - virtual drive pointing at "Developer" directory
rem **   DevAppDrive - virtaul drive pointing at "Developer" applications.
rem **   LibDrive    - virtual drive pointing at "Library" directory
rem **   YBRoot      - directory into which YellowBox is installed
rem **   OSRoot      - directory into which OpenStep is installed
rem **   DefaultRoot - default root if %TargetDrive% is not already mapped
rem **********************************************************************

set SourceDrive=%SystemDrive%
set TargetDrive=Z:
set DemoDrive=V:
set DevDrive=W:
set DevAppDrive=X:
set LibDrive=Y:
set YBRoot=Apple
set OSRoot=NeXT
set DefaultRoot=%YBRoot%

rem **********************************************************************
rem ** Static configuration; should not require modification
rem **********************************************************************

set StartOpt=%1
set ININame=YBOS.ini
set INIPath=%HomeDrive%%HomePath%\.OpenStep
set INIFile=%INIPath%\%ININame%
set SYDaemon=%LibDrive%\System
set AKDaemon=%LibDrive%\Frameworks\AppKit.framework\Resources
set OSPrefix=Next
set YBPrefix=
set OSApps=Apps
set YBApps=Applications
set DriveList=%DemoDrive%, %DevDrive%, %DevAppDrive%, %LibDrive%, %TargetDrive%

rem **********************************************************************
rem ** Need help?
rem **********************************************************************

if "%StartOpt%" == "/?" goto Usage
echo %StartOpt% | findstr /i "help -h /h" > NUL:
if errorlevel 1 goto StopDaemons

:Usage
echo Usage: YBOS [restore^|YellowBox^|OpenStep]              Version 2.0
echo.
echo This script toggles between the Apple Yellow Box DR2 and OpenStep
echo development environments.  Specifically, it stops the daemons, remaps
echo the virtual drives %DriveList%, and then restarts the daemons.
echo.
echo Running this script with no arguments causes it to toggle the virtual
echo drives between %SourceDrive%\%YBRoot% and %SourceDrive%\%OSRoot%.
echo.
echo Running this script with a single argument of "restore" causes it to
echo activate the environment which was most recently active.
echo.
echo Running this script with a single argument of either "YellowBox" or
echo "OpenStep" causes it to activate the specified environment.
echo.
echo Typically a shortcut to this script is placed in the Startup program group
echo so that it runs at login time.  When used in this manner, one of "restore",
echo "YellowBox", or "OpenStep" should be passed in as its sole argument in
echo order to activate the appropriate environment at login time.
echo.
echo This script uses the KILL program in order to stop the running daemons
echo Make sure that KILL.EXE is located somewhere in your Path.
goto AllDone

rem **********************************************************************
rem ** Stop daemons (NOTE: Can not have whitespace after "KILL pattern")
rem **********************************************************************

:StopDaemons
echo Stopping daemons
echo -^> Pasteboard server & kill pbs>          NUL:
echo -^> Window server     & kill WindowServer> NUL:
echo -^> Name server       & kill nmserver>     NUL:
echo -^> Mach daemon       & kill machd>        NUL:
echo.

rem **********************************************************************
rem ** Did user explicitly choose an environment via command line?
rem **********************************************************************

:OptionRestore
echo %StartOpt% | findstr /i "restore" > NUL:
if errorlevel 1 goto OptionYB
if not exist %INIFile% goto DoSubst
rename %INIFile% %ININame%.bat
call %INIFile%.bat
rename %INIFile%.bat %ININame%

:OptionYB
echo %StartOpt% | findstr /i "YellowBox" > NUL:
if errorlevel 1 goto OptionOS
set DefaultRoot=%YBRoot%
goto DoSubst

:OptionOS
echo %StartOpt% | findstr /i "OpenStep" > NUL:
if errorlevel 1 goto TryToggle
set DefaultRoot=%OSRoot%
goto DoSubst

rem **********************************************************************
rem ** Toggle between YBRoot & OSRoot
rem **********************************************************************

:TryToggle
subst | findstr /i "^%TargetDrive%" > NUL:
if errorlevel 1 goto DoSubst

:TryYB
subst | findstr /i "^%TargetDrive%.*%YBRoot%" > NUL:
if errorlevel 1 goto TryNeXT
set DefaultRoot=%OSRoot%
goto DoSubst

:TryNeXT
subst | findstr /i "^%TargetDrive%.*%OSRoot%" > NUL:
if errorlevel 1 goto DoSubst
set DefaultRoot=%YBRoot%

rem **********************************************************************
rem ** Create virtual drives (via subst)
rem **********************************************************************

:DoSubst
echo Toggling to "%DefaultRoot%" & echo.

set PathPrefix=%YBPrefix%
if %DefaultRoot% == %YBRoot% set PathPrefix=%YBPrefix%
if %DefaultRoot% == %OSRoot% set PathPrefix=%OSPrefix%

set AppsDir=%YBApps%
if %DefaultRoot% == %YBRoot% set AppsDir=%YBApps%
if %DefaultRoot% == %OSRoot% set AppsDir=%OSApps%

subst /d %DemoDrive% > NUL:
subst %DemoDrive% %SourceDrive%\%DefaultRoot%\%PathPrefix%Demos

subst /d %DevDrive% > NUL:
subst %DevDrive% %SourceDrive%\%DefaultRoot%\%PathPrefix%Developer

subst /d %DevAppDrive% > NUL:
subst %DevAppDrive% %SourceDrive%\%DefaultRoot%\%PathPrefix%Developer\%AppsDir%

subst /d %LibDrive% > NUL:
subst %LibDrive% %SourceDrive%\%DefaultRoot%\%PathPrefix%Library

subst /d %TargetDrive% > NUL:
subst %TargetDrive% %SourceDrive%\%DefaultRoot%

rem **********************************************************************
rem ** Start daemons
rem **********************************************************************

echo Starting daemons
start /b %SYDaemon%\machd -d     & echo -^> Mach daemon
start /b %SYDaemon%\nmserver -d  & echo -^> Name server
start /b %SYDaemon%\WindowServer & echo -^> Window server
start /b %AKDaemon%\pbs          & echo -^> Pasteboard server

rem **********************************************************************
rem ** Remember configuration
rem **********************************************************************

if not exist %INIPath% mkdir %INIPath%
set StartOpt=YellowBox
if %DefaultRoot% == %YBRoot% set StartOpt=YellowBox
if %DefaultRoot% == %OSRoot% set StartOpt=OpenStep
echo set StartOpt=%StartOpt% > %INIFile%

:AllDone
endlocal
