#import <AppKit/AppKit.h>
#include "QTML.h"
#include "Movies.h"
#include "QTMovie.h"
#include "QuickTimeComponents.h"
#include <windows.h>

typedef long FAR PASCAL _export WndProcFunc(HWND, UINT, WPARAM, LPARAM);

@interface QTView : NSView
{
  QTMovie *movie_;
  MovieController controller_;
  WndProcFunc *windProc;
}

- (id)initWithFrame:(NSRect)frameRect;
- (void)drawRect:(NSRect)aRect;
- (void)dealloc;

- (void)setQTMovie:(id)aQTMovie;
- (id)movie;

- (BOOL)addTweenTrack;
- (BOOL)addTweenMatrixTrack;

- (long)wndProc: (HWND)hWnd :(UINT)message :(WPARAM) wParam :(LPARAM) lParam;

// deleguees de NSWindow :
- (NSSize)windowWillResize:(NSWindow *)sender toSize:(NSSize)proposedFrameSize;
- (void)windowDidResize:(NSNotification *)aNotification;

@end
