/* A2QTMovie.h created by Seb on Sat 20-Sep-1997 */

#ifndef QTMOVIE_H
#define QTMOVIE_H

#import <AppKit/AppKit.h>

#import "QTSpriteManager.h"

// Macintosh headers
#include "QTML.h"
#include "Movies.h"
#include "Scrap.h"

// Windows headers
#include <windows.h>
static int MediaTrackType[5] = {VideoMediaType, SoundMediaType, TextMediaType, MPEGMediaType, MusicMediaType};


@interface QTMovie : NSObject
{
  Movie            movie_;
  NSString*        filename_;
  
  QTSpriteManager* spriteManager_;

}

- (id)initFromFile:(NSString *)filename;
//- (id)init;
- (id)initWithSprite;
- (id)initWithFrame:(NSRect)frameRect;

- (void)setFileName:(NSString *)aFileName;
- (void)dealloc;
- (NSString *)filename;
- (Movie)movie;
- (float)currentTime;
- (int)currentTimeValue;
- (int)movieDuration;
- (int)movieRate;
- (int)movieTimeScale;
- (int)preferredVolume;
- (int)preferredRate;
- (PicHandle)currentImage;
@end

#endif
