#import "QTManager.h"
#import "QTMovie.h"
#import "QTView.h"

// Macintosh headers
#include "QTML.h"
#include "Movies.h"
#include "Scrap.h"

// Windows headers
#include <windows.h>

@interface QTManager (PrivateMethods)
- (BOOL)openFile:(NSString *)filename;
- (BOOL)saveMovieAs;
- (BOOL)newMovieWithSprite;
- (PicHandle)getPictFromFile:(NSString*) filename;
- (BOOL)loadPict;
@end

@implementation QTManager

// actions

- (void)qtOpen:(id)sender
{
  int result;
  NSArray *fileTypes = [NSArray arrayWithObjects:@"mov", nil];
  NSOpenPanel *oPanel = [NSOpenPanel openPanel];
  NSArray *filesToOpen;
  NSString *filename;

  [oPanel setAllowsMultipleSelection:NO];
  [oPanel setCanChooseFiles:YES];
  [oPanel setCanChooseDirectories:YES];

  result = [oPanel runModalForDirectory:NSHomeDirectory() file:nil
                                  types:fileTypes];

  if (result != NSOKButton)
      return;

  filesToOpen = [oPanel filenames];
  filename = [filesToOpen objectAtIndex:0];

  [self openFile:filename];
}

- (void)qtSaveAs:(id)sender {
  [self saveMovieAs];
}

- (void)qtTween:(id)sender {
  [qtView_ addTweenTrack];
}

- (void)qtTweenMatrix:(id)sender {
  [qtView_ addTweenMatrixTrack];
}

- (void)qtSprite:(id)sender {
  [self newMovieWithSprite];
}

- (void)qtLoadPICT:(id)sender {
  [self loadPict];
}

// private methods

static BOOL first = YES;

- (BOOL)saveMovieAs {
  
  FSSpec  sfFile;
  OSType  creator = OSTypeConst('TVOD');
  long	  createMovieFlags = createMovieFileDeleteCurFile;
  long	  movieFlattenFlags = flattenAddMovieToDataFork;
  char    fullPath[255];
  QTMovie* theQTMovie = [qtView_ movie];
  NSString* theFilename = [theQTMovie chooseFile];
    
  if (theFilename!=nil) {

    strcpy(fullPath,[theFilename cString]);
    c2pstr(fullPath);

    // Make a FSSpec with a pascal string filename
    FSMakeFSSpec(0,0L,fullPath, &sfFile);

    // Try to delete the original
    DeleteMovieFile(&sfFile);		

    // FlattenMovie
    DisposeMovie( FlattenMovieData( [theQTMovie movie],
                     movieFlattenFlags,
                     &sfFile,
                     creator,
                     -1,
                     createMovieFlags/*,
                     nil,
                     NULL*/ ) );

    [theQTMovie setFileName:theFilename];
  }
}

- (BOOL)openFile:(NSString *)filename {

  QTMovie* myQTMovie;
  CGrafPtr windowPort;
  
  if (first) {
    CreatePortAssociation([[qtView_ window] windowHandle],0,kQTMLHandlePortEvents);
     first=NO;
  }
  windowPort = GetNativeWindowPort([[qtView_ window] windowHandle]);
   MacSetPort(windowPort);

  if((myQTMovie = [[QTMovie alloc] initFromFile:filename]) != nil) {
    [myQTMovie autorelease];
    [qtView_ setQTMovie:myQTMovie];    
    [qtView_ display];   
    return YES;
  }
  return NO;
}


- (void)qtNewVideo:(id)sender {

  QTMovie* myQTMovie;
  CGrafPtr windowPort;
  NSRect qtViewFrame = [qtView_ frame];
  
  if (first) {
    CreatePortAssociation([[qtView_ window] windowHandle],0,kQTMLHandlePortEvents);
    first=NO;
  }

  windowPort = GetNativeWindowPort([[qtView_ window] windowHandle]);
  MacSetPort(windowPort);

  if((myQTMovie = [[QTMovie alloc] initWithFrame:NSMakeRect(0,0,qtViewFrame.size.width,qtViewFrame.size.height)]) != nil) {
    [myQTMovie autorelease];
    [qtView_ setQTMovie:myQTMovie];
    [qtView_ display];
    return YES;
  }
  return NO;
}

- (BOOL)newMovieWithSprite {

  QTMovie* myQTMovie;
  CGrafPtr windowPort;

  if (first) {
    CreatePortAssociation([[qtView_ window] windowHandle],0,kQTMLHandlePortEvents);
    first=NO;
  }

  windowPort = GetNativeWindowPort([[qtView_ window] windowHandle]);
  MacSetPort(windowPort);

  if((myQTMovie = [[QTMovie alloc] initWithSprite]) != nil) {
    [myQTMovie autorelease];
    [qtView_ setQTMovie:myQTMovie];
    [qtView_ display];
    return YES;
  }
  return NO;
}

-(PicHandle)getPictFromFile:(NSString*) filename {

  char fullPath[255];
  FSSpec fileSpec;
  PicHandle picture =0;
  GraphicsImportComponent gi;
  OSErr err = noErr;
  unsigned long offset,size;

  [filename getCString:fullPath];
  c2pstr(fullPath);

  FSMakeFSSpec(0,0L,fullPath,&fileSpec);

  err = GetGraphicsImporterForFile(&fileSpec, &gi);

  if (err!=noErr)
    printf("GetGraphicsImporterForFile -> err = %d\n",err);

  err = GraphicsImportGetDataOffsetAndSize (gi,&offset,&size);
  printf("< offset = %d ; size = %d >\n",offset,size);

  if (err!=noErr)
    printf("GraphicsImportGetDataOffsetAndSize -> err = %d\n",err);

  picture = (PicHandle)NewHandleClear(size);
  HLock((Handle)picture);
  err = GraphicsImportReadData (gi,(void *)*picture,offset,size);
  if (err!=noErr)
    printf("GraphicsImportReadData -> err = %d\n",err);
  HUnlock((Handle)picture);

  CloseComponent(gi);

  return picture;
}

PicHandle image = nil;

- (BOOL)loadPict {
  image = [self getPictFromFile:@"C:\\images\\icon.pct"];
}

// init & dealloc

 - (id)init {

  OSErr err;
  
  // Initialize QuickTime Media Layer
  err = InitializeQTML(0);

  if (err!=noErr)
    NSLog(@"InitializeQTML error => %d",err);
  
  // Initialize QuickTime
  err = EnterMovies();
  if (err!=noErr)
    NSLog(@"EnterMovies error => %d",err);

  return self;
}

-(void)dealloc {

  if (!first)
    DestroyPortAssociation( [[qtView_ window] windowHandle]);
  
  // Clean up
  ExitMovies();
  TerminateQTML();

}

@end

