/*
 	File:		QD3DShader.h
 
 	Contains:	QuickDraw 3D Shader / Color Routines							
 
 	Version:	Technology:	Quickdraw 3D 1.5.1
 				Release:	QuickTime 3.0
 
 	Copyright:	 1995-1998 by Apple Computer, Inc., all rights reserved.
 
 	Bugs?:		Please include the the file and version information (from above) with
 				the problem description.  Developers belonging to one of the Apple
 				developer programs can submit bug reports to:
 
 					devsupport@apple.com
 
*/
#ifndef __QD3DSHADER__
#define __QD3DSHADER__

#ifndef __QD3D__
#include <QD3D.h>
#endif



#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if PRAGMA_IMPORT
#pragma import on
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=power
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
	#pragma pack(2)
#endif

#if PRAGMA_ENUM_ALWAYSINT
	#pragma enumsalwaysint on
#elif PRAGMA_ENUM_OPTIONS
	#pragma option enum=int
#elif PRAGMA_ENUM_PACK
	#if __option(pack_enums)
		#define PRAGMA_ENUM_PACK__QD3DSHADER__
	#endif
	#pragma options(!pack_enums)
#endif

/******************************************************************************
 **																			 **
 **								RGB Color routines							 **
 **																			 **
 *****************************************************************************/
EXTERN_API_C( TQ3ColorRGB *)
Q3ColorRGB_Set					(TQ3ColorRGB *			color,
								 float 					r,
								 float 					g,
								 float 					b);

EXTERN_API_C( TQ3ColorARGB *)
Q3ColorARGB_Set					(TQ3ColorARGB *			color,
								 float 					a,
								 float 					r,
								 float 					g,
								 float 					b);

EXTERN_API_C( TQ3ColorRGB *)
Q3ColorRGB_Add					(const TQ3ColorRGB *	c1,
								 const TQ3ColorRGB *	c2,
								 TQ3ColorRGB *			result);

EXTERN_API_C( TQ3ColorRGB *)
Q3ColorRGB_Subtract				(const TQ3ColorRGB *	c1,
								 const TQ3ColorRGB *	c2,
								 TQ3ColorRGB *			result);

EXTERN_API_C( TQ3ColorRGB *)
Q3ColorRGB_Scale				(const TQ3ColorRGB *	color,
								 float 					scale,
								 TQ3ColorRGB *			result);

EXTERN_API_C( TQ3ColorRGB *)
Q3ColorRGB_Clamp				(const TQ3ColorRGB *	color,
								 TQ3ColorRGB *			result);

EXTERN_API_C( TQ3ColorRGB *)
Q3ColorRGB_Lerp					(const TQ3ColorRGB *	first,
								 const TQ3ColorRGB *	last,
								 float 					alpha,
								 TQ3ColorRGB *			result);

EXTERN_API_C( TQ3ColorRGB *)
Q3ColorRGB_Accumulate			(const TQ3ColorRGB *	src,
								 TQ3ColorRGB *			result);

EXTERN_API_C( float *)
Q3ColorRGB_Luminance			(const TQ3ColorRGB *	color,
								 float *				luminance);

/******************************************************************************
 **																			 **
 **								Shader Types								 **
 **																			 **
 *****************************************************************************/

enum {
	kQ3ShaderUVBoundaryWrap		= 0,
	kQ3ShaderUVBoundaryClamp	= 1
};

typedef unsigned long 					TQ3ShaderUVBoundary;
/******************************************************************************
 **																			 **
 **								Shader Routines								 **
 **																			 **
 *****************************************************************************/
EXTERN_API_C( TQ3ObjectType )
Q3Shader_GetType				(TQ3ShaderObject 		shader);

EXTERN_API_C( TQ3Status )
Q3Shader_Submit					(TQ3ShaderObject 		shader,
								 TQ3ViewObject 			view);

EXTERN_API_C( TQ3Status )
Q3Shader_SetUVTransform			(TQ3ShaderObject 		shader,
								 const TQ3Matrix3x3 *	uvTransform);

EXTERN_API_C( TQ3Status )
Q3Shader_GetUVTransform			(TQ3ShaderObject 		shader,
								 TQ3Matrix3x3 *			uvTransform);

EXTERN_API_C( TQ3Status )
Q3Shader_SetUBoundary			(TQ3ShaderObject 		shader,
								 TQ3ShaderUVBoundary 	uBoundary);

EXTERN_API_C( TQ3Status )
Q3Shader_SetVBoundary			(TQ3ShaderObject 		shader,
								 TQ3ShaderUVBoundary 	vBoundary);

EXTERN_API_C( TQ3Status )
Q3Shader_GetUBoundary			(TQ3ShaderObject 		shader,
								 TQ3ShaderUVBoundary *	uBoundary);

EXTERN_API_C( TQ3Status )
Q3Shader_GetVBoundary			(TQ3ShaderObject 		shader,
								 TQ3ShaderUVBoundary *	vBoundary);


/******************************************************************************
 **																			 **
 **							Illumination Shader	Classes						 **
 **																			 **
 *****************************************************************************/
EXTERN_API_C( TQ3ObjectType )
Q3IlluminationShader_GetType	(TQ3ShaderObject 		shader);

EXTERN_API_C( TQ3ShaderObject )
Q3PhongIllumination_New			(void);

EXTERN_API_C( TQ3ShaderObject )
Q3LambertIllumination_New		(void);

EXTERN_API_C( TQ3ShaderObject )
Q3NULLIllumination_New			(void);


/******************************************************************************
 **																			 **
 **								 Surface Shader								 **
 **																			 **
 *****************************************************************************/
EXTERN_API_C( TQ3ObjectType )
Q3SurfaceShader_GetType			(TQ3SurfaceShaderObject  shader);


/******************************************************************************
 **																			 **
 **		Texture Shader  - may use any type of Texture. (only 1 type in 1.0)	 **
 **																			 **
 *****************************************************************************/
EXTERN_API_C( TQ3ShaderObject )
Q3TextureShader_New				(TQ3TextureObject 		texture);

EXTERN_API_C( TQ3Status )
Q3TextureShader_GetTexture		(TQ3ShaderObject 		shader,
								 TQ3TextureObject *		texture);

EXTERN_API_C( TQ3Status )
Q3TextureShader_SetTexture		(TQ3ShaderObject 		shader,
								 TQ3TextureObject 		texture);


/******************************************************************************
 **																			 **
 **		Texture Objects - For 1.0, there  is 1 subclass: PixmapTexture.		 **
 **		More subclasses will be added in later releases.					 **
 **			(e.g. PICTTexture, GIFTexture, MipMapTexture)					 **
 **																			 **
 *****************************************************************************/
EXTERN_API_C( TQ3ObjectType )
Q3Texture_GetType				(TQ3TextureObject 		texture);

EXTERN_API_C( TQ3Status )
Q3Texture_GetWidth				(TQ3TextureObject 		texture,
								 unsigned long *		width);

EXTERN_API_C( TQ3Status )
Q3Texture_GetHeight				(TQ3TextureObject 		texture,
								 unsigned long *		height);


/******************************************************************************
 **																			 **
 **		Pixmap Texture													     **
 **			The TQ3StoragePixmap must contain a TQ3StorageObject that is a	 **
 **			Memory Storage ONLY for 1.0. We will support other storage 		 **
 **			classes in later releases.										 **
 **																			 **
 *****************************************************************************/
EXTERN_API_C( TQ3TextureObject )
Q3PixmapTexture_New				(const TQ3StoragePixmap * pixmap);

EXTERN_API_C( TQ3Status )
Q3PixmapTexture_GetPixmap		(TQ3TextureObject 		texture,
								 TQ3StoragePixmap *		pixmap);

EXTERN_API_C( TQ3Status )
Q3PixmapTexture_SetPixmap		(TQ3TextureObject 		texture,
								 const TQ3StoragePixmap * pixmap);


/******************************************************************************
 **																			 **
 **								Mipmap Texture							     **
 **																			 **
 *****************************************************************************/
EXTERN_API_C( TQ3TextureObject )
Q3MipmapTexture_New				(const TQ3Mipmap *		mipmap);

EXTERN_API_C( TQ3Status )
Q3MipmapTexture_GetMipmap		(TQ3TextureObject 		texture,
								 TQ3Mipmap *			mipmap);

EXTERN_API_C( TQ3Status )
Q3MipmapTexture_SetMipmap		(TQ3TextureObject 		texture,
								 const TQ3Mipmap *		mipmap);






#if PRAGMA_ENUM_ALWAYSINT
	#pragma enumsalwaysint reset
#elif PRAGMA_ENUM_OPTIONS
	#pragma option enum=reset
#elif defined(PRAGMA_ENUM_PACK__QD3DSHADER__)
	#pragma options(pack_enums)
#endif

#if PRAGMA_STRUCT_ALIGN
	#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
	#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
	#pragma pack()
#endif

#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif

#ifdef __cplusplus
}
#endif

#endif /* __QD3DSHADER__ */

