/* 
 * AFM hp8 encoding.
 * Copyright (c) 1996 Markku Rossi.
 *
 * Author: Markku Rossi <mtr@iki.fi>
 */

/*
 * This file is part of the AFM library.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "afmint.h"

AFMEncodingTable afm_hp8_encoding[] =
{
  {0x00, AFM_ENC_NONE},
  {0x01, AFM_ENC_NONE},
  {0x02, AFM_ENC_NONE},
  {0x03, AFM_ENC_NONE},
  {0x04, AFM_ENC_NONE},
  {0x05, AFM_ENC_NONE},
  {0x06, AFM_ENC_NONE},
  {0x07, AFM_ENC_NONE},
  {0x08, AFM_ENC_NONE},
  {0x09, AFM_ENC_NONE},
  {0x0a, AFM_ENC_NONE},
  {0x0b, AFM_ENC_NONE},
  {0x0c, AFM_ENC_NONE},
  {0x0d, AFM_ENC_NONE},
  {0x0e, AFM_ENC_NONE},
  {0x0f, AFM_ENC_NONE},
  {0x10, AFM_ENC_NONE},
  {0x11, AFM_ENC_NONE},
  {0x12, AFM_ENC_NONE},
  {0x13, AFM_ENC_NONE},
  {0x14, AFM_ENC_NONE},
  {0x15, AFM_ENC_NONE},
  {0x16, AFM_ENC_NONE},
  {0x17, AFM_ENC_NONE},
  {0x18, AFM_ENC_NONE},
  {0x19, AFM_ENC_NONE},
  {0x1a, AFM_ENC_NONE},
  {0x1b, AFM_ENC_NONE},
  {0x1c, AFM_ENC_NONE},
  {0x1d, AFM_ENC_NONE},
  {0x1e, AFM_ENC_NONE},
  {0x1f, AFM_ENC_NONE},
  {0x20, "space"},
  {0x21, "exclam"},
  {0x22, "quotedbl"},
  {0x23, "numbersign"},
  {0x24, "dollar"},
  {0x25, "percent"},
  {0x26, "ampersand"},
  {0x27, "quoteright"},
  {0x28, "parenleft"},
  {0x29, "parenright"},
  {0x2a, "asterisk"},
  {0x2b, "plus"},
  {0x2c, "comma"},
  {0x2d, "hyphen"},
  {0x2e, "period"},
  {0x2f, "slash"},
  {0x30, "zero"},
  {0x31, "one"},
  {0x32, "two"},
  {0x33, "three"},
  {0x34, "four"},
  {0x35, "five"},
  {0x36, "six"},
  {0x37, "seven"},
  {0x38, "eight"},
  {0x39, "nine"},
  {0x3a, "colon"},
  {0x3b, "semicolon"},
  {0x3c, "less"},
  {0x3d, "equal"},
  {0x3e, "greater"},
  {0x3f, "question"},
  {0x40, "at"},
  {0x41, "A"},
  {0x42, "B"},
  {0x43, "C"},
  {0x44, "D"},
  {0x45, "E"},
  {0x46, "F"},
  {0x47, "G"},
  {0x48, "H"},
  {0x49, "I"},
  {0x4a, "J"},
  {0x4b, "K"},
  {0x4c, "L"},
  {0x4d, "M"},
  {0x4e, "N"},
  {0x4f, "O"},
  {0x50, "P"},
  {0x51, "Q"},
  {0x52, "R"},
  {0x53, "S"},
  {0x54, "T"},
  {0x55, "U"},
  {0x56, "V"},
  {0x57, "W"},
  {0x58, "X"},
  {0x59, "Y"},
  {0x5a, "Z"},
  {0x5b, "bracketleft"},
  {0x5c, "backslash"},
  {0x5d, "bracketright"},
  {0x5e, "asciicircum"},
  {0x5f, "underscore"},
  {0x60, "quoteleft"},
  {0x61, "a"},
  {0x62, "b"},
  {0x63, "c"},
  {0x64, "d"},
  {0x65, "e"},
  {0x66, "f"},
  {0x67, "g"},
  {0x68, "h"},
  {0x69, "i"},
  {0x6a, "j"},
  {0x6b, "k"},
  {0x6c, "l"},
  {0x6d, "m"},
  {0x6e, "n"},
  {0x6f, "o"},
  {0x70, "p"},
  {0x71, "q"},
  {0x72, "r"},
  {0x73, "s"},
  {0x74, "t"},
  {0x75, "u"},
  {0x76, "v"},
  {0x77, "w"},
  {0x78, "x"},
  {0x79, "y"},
  {0x7a, "z"},
  {0x7b, "braceleft"},
  {0x7c, "bar"},
  {0x7d, "braceright"},
  {0x7e, "tilde"},
  {0x7f, AFM_ENC_NONE},
  {0x80, AFM_ENC_NONE},
  {0x81, AFM_ENC_NONE},
  {0x82, AFM_ENC_NONE},
  {0x83, AFM_ENC_NONE},
  {0x84, AFM_ENC_NONE},
  {0x85, AFM_ENC_NONE},
  {0x86, AFM_ENC_NONE},
  {0x87, AFM_ENC_NONE},
  {0x88, AFM_ENC_NONE},
  {0x89, AFM_ENC_NONE},
  {0x8a, AFM_ENC_NONE},
  {0x8b, AFM_ENC_NONE},
  {0x8c, AFM_ENC_NONE},
  {0x8d, AFM_ENC_NONE},
  {0x8e, AFM_ENC_NONE},
  {0x8f, AFM_ENC_NONE},
  {0x90, AFM_ENC_NONE},
  {0x91, AFM_ENC_NONE},
  {0x92, AFM_ENC_NONE},
  {0x93, AFM_ENC_NONE},
  {0x94, AFM_ENC_NONE},
  {0x95, AFM_ENC_NONE},
  {0x96, AFM_ENC_NONE},
  {0x97, AFM_ENC_NONE},
  {0x98, AFM_ENC_NONE},
  {0x99, AFM_ENC_NONE},
  {0x9a, AFM_ENC_NONE},
  {0x9b, AFM_ENC_NONE},
  {0x9c, AFM_ENC_NONE},
  {0x9d, AFM_ENC_NONE},
  {0x9e, AFM_ENC_NONE},
  {0x9f, AFM_ENC_NONE},
  {0xa0, AFM_ENC_NONE},
  {0xa1, "Agrave"},
  {0xa2, "Acircumflex"},
  {0xa3, "Egrave"},
  {0xa4, "Ecircumflex"},
  {0xa5, "Edieresis"},
  {0xa6, "Icircumflex"},
  {0xa7, "Idieresis"},
  {0xa8, "acute"},
  {0xa9, "grave"},
  {0xaa, "circumflex"},
  {0xab, "dieresis"},
  {0xac, "tilde"},
  {0xad, "Ugrave"},
  {0xae, "Ucircumflex"},
  {0xaf, "sterling"},
  {0xb0, "macron"},
  {0xb1, "Yacute"},
  {0xb2, "yacute"},
  {0xb3, "degree"},
  {0xb4, "Ccedilla"},
  {0xb5, "ccedilla"},
  {0xb6, "Ntilde"},
  {0xb7, "ntilde"},
  {0xb8, "exclamdown"},
  {0xb9, "questiondown"},
  {0xba, "currency"},
  {0xbb, "sterling"},
  {0xbc, "yen"},
  {0xbd, "section"},
  {0xbe, "florin"},
  {0xbf, "cent"},
  {0xc0, "acircumflex"},
  {0xc1, "ecircumflex"},
  {0xc2, "ocircumflex"},
  {0xc3, "ucircumflex"},
  {0xc4, "aacute"},
  {0xc5, "eacute"},
  {0xc6, "oacute"},
  {0xc7, "uacute"},
  {0xc8, "agrave"},
  {0xc9, "egrave"},
  {0xca, "ograve"},
  {0xcb, "ugrave"},
  {0xcc, "adieresis"},
  {0xcd, "edieresis"},
  {0xce, "odieresis"},
  {0xcf, "udieresis"},
  {0xd0, "Aring"},
  {0xd1, "icircumflex"},
  {0xd2, "Oslash"},
  {0xd3, "AE"},
  {0xd4, "aring"},
  {0xd5, "iacute"},
  {0xd6, "oslash"},
  {0xd7, "ae"},
  {0xd8, "Adieresis"},
  {0xd9, "igrave"},
  {0xda, "Odieresis"},
  {0xdb, "Udieresis"},
  {0xdc, "Eacute"},
  {0xdd, "idieresis"},
  {0xde, "germandbls"},
  {0xdf, "Ocircumflex"},
  {0xe0, "Aacute"},
  {0xe1, "Atilde"},
  {0xe2, "atilde"},
  {0xe3, "Eth"},
  {0xe4, "eth"},
  {0xe5, "Iacute"},
  {0xe6, "Igrave"},
  {0xe7, "Oacute"},
  {0xe8, "Ograve"},
  {0xe9, "Otilde"},
  {0xea, "otilde"},
  {0xeb, "Scaron"},
  {0xec, "scaron"},
  {0xed, "Uacute"},
  {0xee, "Ydieresis"},
  {0xef, "ydieresis"},
  {0xf0, "Thorn"},
  {0xf1, "thorn"},
  {0xf2, "periodcentered"},
  {0xf3, "mu"},
  {0xf4, "paragraph"},
  {0xf5, "threequarters"},
  {0xf6, "emdash"},
  {0xf7, "onequarter"},
  {0xf8, "onehalf"},
  {0xf9, "ordfeminine"},
  {0xfa, "ordmasculine"},
  {0xfb, "guillemotleft"},
  {0xfc, "filledbox"},
  {0xfd, "guillemotright"},
  {0xfe, "plusminus"},
  {0xff, AFM_ENC_NONE},
  {-1,   NULL},
};
