#ifndef __SokoScore_h
#define __SokoScore_h
//-----------------------------------------------------------------------------
// SokoScore.h
//
//	"Top-Scores" object for SokoSave.
//
// Copyright (c), 1997, Paul McCarthy.  All rights reserved.
// Copyright (c), 1997, Eric Sunshine.  All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoScore.h,v 1.2 97/12/10 07:02:40 sunshine Exp $
// $Log:	SokoScore.h,v $
//  Revision 1.2  97/12/10  07:02:40  sunshine
//  v10.1: Ported to OPENSTEP 4.1 for Mach, OPENSTEP 4.2 for Mach & Windows,
//  and Rhapsody Developer Release (RDR) for Mach and Windows (Yellow Box).
//  Now allows only horizontal resizing of "New Score" panel.
//  Replaced MiscTableScroll with NSTableView.
//  
//  Revision 1.1  97/11/13  02:59:08  zarnuk
//  v9
//-----------------------------------------------------------------------------
extern "Objective-C" {
#import <Foundation/NSObject.h>
@class NSArray, NSPanel, NSTableView, NSTextField, NSWindow;
}

@interface SokoScore : NSObject
    {
    NSWindow* window;
    NSTableView* tableView;
    NSPanel* newPanel;
    NSTextField* newMaze;
    NSTextField* newMoves;
    NSTextField* newName;
    NSTextField* newNotes;
    NSTextField* newPushes;
    NSArray* scores;
    BOOL dirty;
    BOOL saveSizes;
    BOOL saveOrder;
    NSArray* columnOrder;
    }

+ (void)launch;
+ (void)solved:(NSString*)maze moves:(int)moves pushes:(int)pushes;
+ (void)terminate;

@end

#endif // __SokoScore_h
