//-----------------------------------------------------------------------------
// SokoPref.M
//
//	User preferences module for SokoSave.
//
// Copyright (c), 1997, Paul McCarthy.  All rights reserved.
// Copyright (c), 1997, Eric Sunshine.  All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoPref.M,v 1.2 97/12/10 07:00:19 sunshine Exp $
// $Log:	SokoPref.M,v $
//  Revision 1.2  97/12/10  07:00:19  sunshine
//  v10.1: Ported to OPENSTEP 4.1 for Mach, OPENSTEP 4.2 for Mach & Windows,
//  and Rhapsody Developer Release (RDR) for Mach and Windows (Yellow Box).
//  Fields are now reverted to their saved values when Cancel is pressed.
//  Set button now dismisses the panel.  Now marks the window dirty as changes
//  are made and, if dirty, prompts user when window's close button is pressed.
//  Now saves screen position.
//  
//  Revision 1.1  97/11/13  02:57:01  zarnuk
//  v9
//-----------------------------------------------------------------------------
#import	"SokoDefs.h"
#import "SokoPref.h"
#import "SokoFiles.h"
extern "Objective-C" {
#import <AppKit/NSButton.h>
#import <AppKit/NSNibLoading.h>
#import <AppKit/NSPanel.h>
#import <AppKit/NSTextField.h>
#import <Foundation/NSUserDefaults.h>
}

@implementation SokoPref

//-----------------------------------------------------------------------------
// +getLevel
//-----------------------------------------------------------------------------
+ (int)getLevel
    {
    int const i = [[NSUserDefaults standardUserDefaults] integerForKey:LEVEL];
    return (i < 1 ? 1 : i);
    }


//-----------------------------------------------------------------------------
// +setLevel:
//-----------------------------------------------------------------------------
+ (void)setLevel:(int)level
    {
    [[NSUserDefaults standardUserDefaults] setInteger:level forKey:LEVEL];
    }


//-----------------------------------------------------------------------------
// +doesAutoSave
//-----------------------------------------------------------------------------
+ (BOOL)doesAutoSave
    {
    return [[NSUserDefaults standardUserDefaults] boolForKey:AUTO_SAVE];
    }


//-----------------------------------------------------------------------------
// +setAutoSave:
//-----------------------------------------------------------------------------
+ (void)setAutoSave:(BOOL)flag
    {
    [[NSUserDefaults standardUserDefaults] setBool:flag forKey:AUTO_SAVE];
    }


//-----------------------------------------------------------------------------
// -loadFields
//-----------------------------------------------------------------------------
- (void)loadFields
    {
    [saveDirField setStringValue:getSaveDirectory()];
    [mazeDirField setStringValue:getMazeDirectory()];
    [scoresFileField setStringValue:getScoresFile()];
    [levelField setIntValue:[[self class] getLevel]];
    [autoSaveSwitch setState:[[self class] doesAutoSave]];
    }


//-----------------------------------------------------------------------------
// -saveFields
//-----------------------------------------------------------------------------
- (void)saveFields
    {
    NSUserDefaults* const defs = [NSUserDefaults standardUserDefaults];
    [defs setObject:[saveDirField stringValue] forKey:SAVE_DIR];
    [defs setObject:[mazeDirField stringValue] forKey:MAZE_DIR];
    [defs setObject:[scoresFileField stringValue] forKey:SCORES];
    [[self class] setLevel:[levelField intValue]];
    [[self class] setAutoSave:[autoSaveSwitch state]];
    }


//-----------------------------------------------------------------------------
// -closeWindow
//-----------------------------------------------------------------------------
- (void)closeWindow
    {
    [window setDocumentEdited:NO];
    [window close];
    visible = NO;
    }


//-----------------------------------------------------------------------------
// doDefaults:
//-----------------------------------------------------------------------------
- (void)doDefaults:(id)sender
    {
    [saveDirField setStringValue:DEF_SAVE_DIR];
    [mazeDirField setStringValue:DEF_MAZE_DIR];
    [scoresFileField setStringValue:DEF_SCORES];
    [levelField setStringValue:@"1"];
    [autoSaveSwitch setState:1];
    [window setDocumentEdited:YES];
    }


//-----------------------------------------------------------------------------
// -madeDirty:
//-----------------------------------------------------------------------------
- (void)madeDirty:(id)sender
    {
    [window setDocumentEdited:YES];
    }


//-----------------------------------------------------------------------------
// -doSet:
//-----------------------------------------------------------------------------
- (void)doSet:(id)sender
    {
    [self saveFields];
    [self closeWindow];
    }


//-----------------------------------------------------------------------------
// -doCancel:
//-----------------------------------------------------------------------------
- (void)doCancel:(id)sender
    {
    [self closeWindow];
    }


//-----------------------------------------------------------------------------
// -controlTextDidChange:
//-----------------------------------------------------------------------------
- (void)controlTextDidChange:(NSNotification*)notification
    {
    [self madeDirty:self];
    }


//-----------------------------------------------------------------------------
// -windowShouldClose:
//	NOTE *1*: If we fail to end editing in a field which the user had
//	changed, the value is not restored the next time the panel is launched.
//-----------------------------------------------------------------------------
- (BOOL)windowShouldClose:(id)sender
    {
    BOOL ok = YES;
    if ([window isDocumentEdited])
	{
	int const rc = NSRunAlertPanel( @"Preferences",
	    @"Save your changes to the preferences?",
	    @"Save", @"Don't Save", @"Cancel" );
	if (rc == NSAlertDefaultReturn)
	    [self saveFields];
	else if (rc == NSAlertAlternateReturn)
	    [window makeFirstResponder:window];	// NOTE *1*
	else // (rc == NSAlertOtherReturn)
	    ok = NO;
	}
    if (ok)
	[self closeWindow];
    return ok;
    }


//-----------------------------------------------------------------------------
// -makeKeyAndOrderFront:
//-----------------------------------------------------------------------------
- (void)makeKeyAndOrderFront:(id)sender
    {
    if (!visible)
	[self loadFields];
    [window makeKeyAndOrderFront:sender];
    }


//-----------------------------------------------------------------------------
// -init
//-----------------------------------------------------------------------------
- (id)init
    {
    [super init];
    [NSBundle loadNibNamed:@"SokoPref" owner:self];
    [window setFrameAutosaveName:@"SokoPref"];
    [self loadFields];
    visible = NO;
    return self;
    }


//-----------------------------------------------------------------------------
// +commonInstance
//-----------------------------------------------------------------------------
+ (SokoPref*)commonInstance
    {
    static SokoPref* instance = 0;
    if (instance == 0)
	instance = [[self alloc] init];
    return instance;
    }


//-----------------------------------------------------------------------------
// +launch
//-----------------------------------------------------------------------------
+ (void)launch
    {
    [[self commonInstance] makeKeyAndOrderFront:self];
    }

@end
