//-----------------------------------------------------------------------------
// SokoMouse.m
//
//	Handle O/S differences in mouse handling.
//
// Copyright (c), 1997, Paul McCarthy.  All rights reserved.
// Copyright (c), 1997, Eric Sunshine.  All rights reserved.
//
// Platform and O/S specific definitions:
//
// SokoMoveMouse()
//	The click-crate-to-move feature requires moving the mouse pointer 
//	along with the crate.  Under OPENSTEP and Rhapsody for Mach, this is 
//	accomplished via PSadjustcursor().  However, under MS-Windows, 
//	PSadjustcursor() is a no-op, and native Windows calls must be used.  
//	Unfortunately the Objective-C++ compiler under Windows fails to import 
//	the Windows headers correctly and spews hundreds of errors.  Hence 
//	this file is straight Objective-C, rather than C++, since the C 
//	compiler handles the same headers fine.  
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoMouse.m,v 1.1 97/12/10 07:12:57 sunshine Exp $
// $Log:	SokoMouse.m,v $
// Revision 1.1  97/12/10  07:12:57  sunshine
// v10.1: Encapsulates mouse-pointer movement code, which differs between
// Mach and Windows platforms.
// 
//-----------------------------------------------------------------------------
#import "SokoDefs.h"
#if !defined(__WIN32__)
# import <AppKit/psopsNeXT.h>
#else
# import <wtypes.h>
# import <winuser.h>
#endif

//-----------------------------------------------------------------------------
// SokoMoveMouse
//-----------------------------------------------------------------------------
void SokoMoveMouse( int dx, int dy )
    {
#if !defined(__WIN32__)
    PSadjustcursor( dx, dy );
#else
    POINT p;
    GetCursorPos(&p);
    SetCursorPos( p.x + dx, p.y + dy );
#endif
    }
