#ifndef __SokoFiles_h
#define __SokoFiles_h
//-----------------------------------------------------------------------------
// SokoFiles.h
//
//	Utility routines for manipulating filenames.
//
// Copyright (c), 1997, Paul McCarthy.  All rights reserved.
// Copyright (c), 1997, Eric Sunshine.  All rights reserved.
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
// $Id: SokoFiles.h,v 1.2 97/12/10 06:58:39 sunshine Exp $
// $Log:	SokoFiles.h,v $
//  Revision 1.2  97/12/10  06:58:39  sunshine
//  v10.1: Ported to OPENSTEP 4.1 for Mach, OPENSTEP 4.2 for Mach & Windows,
//  and Rhapsody Developer Release (RDR) for Mach and Windows (Yellow Box).
//  Now handles DOS-style and Microsoft UNC-style paths.
//  
//  Revision 1.1  97/11/13  02:55:48  zarnuk
//  v9
//-----------------------------------------------------------------------------
extern "Objective-C" {
#import <Foundation/NSObject.h>
}

NSString* getMazeDirectory();
NSString* getMazeExtension();
NSString* getSaveDirectory();
NSString* getSaveExtension();
NSString* getScoresFile();
NSString* getFactoryScoresFile();
NSString* collapse( NSString* filename );
NSString* expand( NSString* filename );
NSString* filenamePart( NSString* path );
NSString* directoryPart( NSString* path );
NSString* saveFileNameForMazeName( NSString* mazeName );
NSString* mazeNameForLevel( int level );
BOOL mkdirs( NSString* );

#endif // __SokoFiles_h
