//---------------------------------------------------------------------------------------
// created as RSSParser.m by znek on Sun 29-Oct-2000
// $Id: RSSParser.m,v 1.3 2001/07/27 10:25:36 znek Exp $
//
//  Copyright (c) 2000 by Marcus Mueller <znek@mulle-kybernetik.com>.
//  All rights reserved.
//
//  Permission to use, copy, modify and distribute this software and its documentation
//  is hereby granted under the terms of the GNU General Public License, version 2
//  as published by the Free Software Foundation, provided that both the copyright notice
//  and this permission notice appear in all copies of the software, derivative works or
//  modified versions, and any portions thereof, and that both notices appear in supporting
//  documentation, and that credit is given to Marcus Mueller in all documents and publicity
//  pertaining to direct or indirect use of this code or its derivatives.
//
//  This is free software; you can redistribute and/or modify it under
//  the terms of the GNU General Public License, version 2 as published by the Free
//  Software Foundation. Further information can be found on the project's web pages
//  at http://www.mulle-kybernetik.com/software/MKPortal
//
//  THIS IS EXPERIMENTAL SOFTWARE AND IT IS KNOWN TO HAVE BUGS, SOME OF WHICH MAY HAVE
//  SERIOUS CONSEQUENCES. THE COPYRIGHT HOLDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS
//  "AS IS" CONDITION. THE COPYRIGHT HOLDER DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY
//  DAMAGES WHATSOEVER RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE
//  OR OF ANY DERIVATIVE WORK.
//---------------------------------------------------------------------------------------


#import "RSSParser.h"
#import <EDInternet/EDInternet.h>
#import "MXElement.h"
#import "RSSDocument.h"
#import "XMLInfo.h"


@implementation RSSParser

////////////////////////////////////////////////////
//
//  FUTURE COMPATIBILITY
//
////////////////////////////////////////////////////


- (NSDictionary *)tagDefinitionForTagNamed:(NSString *)tagName
{
    NSDictionary *tagDef = [super tagDefinitionForTagNamed:tagName];
    
    if(tagDef == nil)
    {
        // The invention of RSS 1.0 (RDF) brings along a lot of different namespaces
        // which we don't need to handle necessarily. In any case, it's best for us to do
        // "best effort" on parsing the tags. Thus unknown tags will be represented as
        // text containers.
        
        tagDef = [NSMutableDictionary dictionaryWithCapacity:3];
        [(NSMutableDictionary *)tagDef setObject:[NSArray arrayWithObject:[NSDictionary dictionaryWithObject:tagName forKey:@"key"]] forKey:@"implicit"];
        [(NSMutableDictionary *)tagDef setObject:@"MXTextContainerElement" forKey:@"class"];
        [(NSMutableDictionary *)tagDef setObject:@"YES" forKey:@"container"];
    }
    return tagDef;
}


////////////////////////////////////////////////////
//
//  CONVENIENCE
//
////////////////////////////////////////////////////


- (RSSDocument *)documentFromXMLData:(NSData *)rssData
{
	NSEnumerator *rssEnum;
	MXElement *element;
	RSSDocument *document = nil;
	XMLInfo *info = nil;

	rssEnum = [[self parseXMLDocument:rssData] objectEnumerator];
	while((element = [rssEnum nextObject]) != nil)
	{
	if([element isKindOfClass:[RSSDocument class]])
		document = (RSSDocument *)element;
	else if([element isKindOfClass:[XMLInfo class]])
		info = (XMLInfo *)element;
	}
	if(info != nil)
		[document setEncoding:[info encoding]];
	return document;
}

@end
