//---------------------------------------------------------------------------------------
// created as RSSImage.m by znek on Sun 29-Oct-2000
// $Id: RSSImage.m,v 1.1.1.1 2001/07/23 06:50:23 znek Exp $
//
//  Copyright (c) 2000 by Marcus Mueller <znek@mulle-kybernetik.com>.
//  All rights reserved.
//
//  Permission to use, copy, modify and distribute this software and its documentation
//  is hereby granted under the terms of the GNU General Public License, version 2
//  as published by the Free Software Foundation, provided that both the copyright notice
//  and this permission notice appear in all copies of the software, derivative works or
//  modified versions, and any portions thereof, and that both notices appear in supporting
//  documentation, and that credit is given to Marcus Mueller in all documents and publicity
//  pertaining to direct or indirect use of this code or its derivatives.
//
//  This is free software; you can redistribute and/or modify it under
//  the terms of the GNU General Public License, version 2 as published by the Free
//  Software Foundation. Further information can be found on the project's web pages
//  at http://www.mulle-kybernetik.com/software/MKPortal
//
//  THIS IS EXPERIMENTAL SOFTWARE AND IT IS KNOWN TO HAVE BUGS, SOME OF WHICH MAY HAVE
//  SERIOUS CONSEQUENCES. THE COPYRIGHT HOLDER ALLOWS FREE USE OF THIS SOFTWARE IN ITS
//  "AS IS" CONDITION. THE COPYRIGHT HOLDER DISCLAIMS ANY LIABILITY OF ANY KIND FOR ANY
//  DAMAGES WHATSOEVER RESULTING DIRECTLY OR INDIRECTLY FROM THE USE OF THIS SOFTWARE
//  OR OF ANY DERIVATIVE WORK.
//---------------------------------------------------------------------------------------


#import "RSSImage.h"


@implementation RSSImage

////////////////////////////////////////////////////
//
//	ACCESSORS
//
////////////////////////////////////////////////////


- (NSString *)width
{
  NSString *width = [self valueForAttribute:@"width"];
  if(width == nil)
    width = @"88"; // according to v0.91 specs
  return width;
}

- (NSString *)height
{
  NSString *height = [self valueForAttribute:@"height"];
  if(height == nil)
    height = @"31"; // according to v0.91 specs
  return height;
}

- (NSString *)title
{
  return [self valueForAttribute:@"title"];
}

- (NSString *)link
{
  return [self valueForAttribute:@"link"];
}

- (NSString *)url
{
  return [self valueForAttribute:@"url"];
}



////////////////////////////////////////////////////
//
//	DEBUGGING
//
////////////////////////////////////////////////////


- (NSString *)description
{
  return [NSString stringWithFormat:@"<%@ 0x%x: title=\"%@\" link=\"%@\" url=\"%@\">", NSStringFromClass([self class]), self, [self title], [self link], [self url]];
}

@end
